/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DrainLifeBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public DrainLifeBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.drainLifeBoundary.get(), p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DRAIN_LIFE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        final Player caster = this.getCaster();
        for (final LivingEntity e : entities) {
            final float tmpHealth = e.m_21223_();
            if (EffectUtil.inEntityBlacklist((Entity)e, MTConfig.DRAIN_LIFE_ENTITY_BLACKLIST) || !this.drainLife(e) || caster == null || !(this.f_58857_ instanceof ServerLevel) || this.f_58857_.m_142572_() == null) continue;
            ((ServerLevel)this.f_58857_).m_142572_().m_6937_((Runnable)new TickTask(1, new Runnable(){

                @Override
                public void run() {
                    float newHealth = e.m_21223_();
                    if ((double)(tmpHealth - newHealth) >= MTConfig.DRAIN_LIFE_DAMAGE || !e.m_6084_()) {
                        DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                    } else {
                        EffectUtil.genericAttack(e, (float)(MTConfig.DRAIN_LIFE_DAMAGE * MTConfig.DRAIN_LIFE_PUNISH_RESIST), DamageSource.f_19318_, (LivingEntity)caster);
                        DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                    }
                }
            }));
        }
    }

    public boolean drainLife(LivingEntity entityIn) {
        if (!ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), (Entity)entityIn)) {
            EffectUtil.magicAttack(entityIn, (float)MTConfig.DRAIN_LIFE_DAMAGE, (LivingEntity)this.getCaster());
            return true;
        }
        return false;
    }

    public void giveLife(Player caster) {
        if (caster.m_21223_() >= caster.m_21233_()) {
            FoodData casterFS = caster.m_36324_();
            if (casterFS.m_38702_() >= 20 || MTConfig.DRAIN_LIFE_IGNORE_HUNGER) {
                IMahou mahou = Utils.getPlayerMahou(caster);
                if (mahou != null) {
                    mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + MTConfig.DRAIN_LIFE_MANA_REGEN));
                }
            } else {
                casterFS.m_38705_(casterFS.m_38702_() + 1);
            }
        } else {
            caster.m_5634_((float)MTConfig.DRAIN_LIFE_HEAL_FACTOR);
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryDrainLifeScroll);
    }
}

