/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api;

import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public final class GearApi {
    private GearApi() {
        throw new IllegalAccessError("Utility class");
    }

    public static void recalculateStats(ItemStack gear, @Nullable Player player) {
        GearData.recalculateStats(gear, player);
    }

    public static boolean isBroken(ItemStack gear) {
        return GearHelper.isBroken(gear);
    }

    public static boolean isGear(ItemStack stack) {
        return GearHelper.isGear(stack);
    }

    public static float getStat(ItemStack gear, IItemStat stat) {
        return GearData.getStat(gear, stat);
    }

    public static int getStatInt(ItemStack gear, IItemStat stat) {
        return GearData.getStatInt(gear, stat);
    }

    @Nullable
    public static IPartData getPartOfType(ItemStack gear, PartType type) {
        return GearData.getPartOfType(gear, type);
    }

    @Nullable
    public static IPartData getMainPart(ItemStack gear) {
        return GearData.getPrimaryPart(gear);
    }

    public static void attemptDamageGear(ItemStack gear, int amount, @Nullable Player player, InteractionHand hand) {
        GearHelper.attemptDamage(gear, amount, (LivingEntity)player, hand);
    }

    public static void attemptDamageGear(ItemStack gear, int amount, @Nullable Player player, EquipmentSlot slot) {
        GearHelper.attemptDamage(gear, amount, (LivingEntity)player, slot);
    }

    public static UUID getUuid(ItemStack gear) {
        return GearData.getUUID(gear);
    }

    public static int getTraitLevel(ItemStack gear, DataResource<ITrait> trait) {
        return GearApi.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ResourceLocation traitId) {
        return TraitHelper.getTraitLevel(gear, traitId);
    }

    public static void registerTraitSerializer(ITraitSerializer<?> serializer) {
        TraitSerializers.register(serializer);
    }

    @Nullable
    public static IMaterial getMaterial(ResourceLocation id) {
        return MaterialManager.get(id);
    }

    @Nullable
    public static IMaterialInstance getMaterial(ItemStack stack) {
        return MaterialInstance.from(stack);
    }

    public static Collection<IMaterial> getMaterials() {
        return MaterialManager.getValues();
    }

    public static Collection<IMaterial> getMaterials(boolean includeChildren) {
        return MaterialManager.getValues(includeChildren);
    }

    public static boolean isMaterial(ItemStack stack) {
        return MaterialManager.from(stack) != null;
    }

    @Nullable
    public static IGearPart getPart(ResourceLocation id) {
        return PartManager.get(id);
    }

    @Nullable
    public static IPartData getPart(ItemStack stack) {
        return PartData.from(stack);
    }

    public static Collection<IGearPart> getValues() {
        return PartManager.getValues();
    }

    public static ResourceLocation modId(String key) {
        return SilentGear.getIdWithDefaultNamespace(key);
    }

    public static String shortenId(ResourceLocation id) {
        return SilentGear.shortenId(id);
    }
}

