/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.utils.Color;

public class SplitItemStat
extends ItemStat {
    private final Map<GearType, Float> splits = new LinkedHashMap<GearType, Float>();
    private final float splitsTotal;

    public SplitItemStat(float defaultValue, float minValue, float maxValue, ChatFormatting nameColor, Map<GearType, Float> splitsIn, ItemStat.Properties properties) {
        super(defaultValue, minValue, maxValue, nameColor, properties);
        this.splits.putAll(splitsIn);
        this.splitsTotal = (float)this.splits.values().stream().mapToDouble(f -> f.floatValue()).sum();
    }

    public SplitItemStat(float defaultValue, float minValue, float maxValue, Color nameColor, Map<GearType, Float> splitsIn, ItemStat.Properties properties) {
        super(defaultValue, minValue, maxValue, nameColor, properties);
        this.splits.putAll(splitsIn);
        this.splitsTotal = (float)this.splits.values().stream().mapToDouble(f -> f.floatValue()).sum();
    }

    @Override
    public float compute(float baseValue, boolean clampValue, GearType itemGearType, GearType statGearType, Collection<StatInstance> modifiers) {
        float value = super.compute(baseValue, clampValue, itemGearType, statGearType, modifiers);
        if (!statGearType.equals(itemGearType) && this.splits.containsKey(itemGearType)) {
            return value * this.splits.get(itemGearType).floatValue() / this.splitsTotal;
        }
        return value;
    }

    public Collection<GearType> getSplitTypes() {
        return this.splits.keySet();
    }

    public float getSplitsTotal() {
        return this.splitsTotal;
    }
}

