/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.GsonHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstanceWithSource;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;
import org.apache.commons.lang3.NotImplementedException;

public class StatInstance {
    public static final StatGearKey DEFAULT_KEY = StatGearKey.of(() -> SilentGear.getId("null"), GearType.ALL);
    private static final Pattern REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
    private static final Pattern REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");
    final float value;
    final Operation op;
    final StatGearKey key;

    protected StatInstance(float value, Operation op, StatGearKey key) {
        this.value = value;
        this.op = op;
        this.key = key;
    }

    @Deprecated
    public static StatInstance of(float value) {
        return StatInstance.of(value, Operation.AVG, DEFAULT_KEY);
    }

    @Deprecated
    public static StatInstance of(float value, Operation op) {
        return StatInstance.of(value, op, DEFAULT_KEY);
    }

    public static StatInstance of(float value, Operation op, StatGearKey key) {
        return new StatInstance(value, op, key);
    }

    @Deprecated
    public static StatInstance withSource(float value, String source) {
        return StatInstance.withSource(value, Operation.AVG, source);
    }

    @Deprecated
    public static StatInstance withSource(float value, Operation op, String source) {
        return StatInstance.withSource(value, op, DEFAULT_KEY, source);
    }

    public static StatInstance withSource(float value, Operation op, StatGearKey key, String source) {
        return new StatInstanceWithSource(value, op, key, source);
    }

    public StatInstance copySetValue(float newValue) {
        return StatInstance.of(newValue, this.op, this.key);
    }

    public StatInstance copy() {
        return new StatInstance(this.value, this.op, this.key);
    }

    public float getValue() {
        return this.value;
    }

    public Operation getOp() {
        return this.op;
    }

    public StatGearKey getKey() {
        return this.key;
    }

    public String getSource() {
        return "N/A";
    }

    public static StatInstance getWeightedAverageMod(Collection<StatInstance> modifiers, Operation op) {
        float value = ItemStat.getWeightedAverage(modifiers, op);
        StatGearKey key = StatInstance.getMostSpecificKey(modifiers);
        return new StatInstance(value, op, key);
    }

    public static StatInstance getMaterialWeightedAverageMod(Collection<StatInstance> modifiers, Operation op) {
        float value = ItemStat.getMaterialWeightedAverage(modifiers, op);
        StatGearKey key = StatInstance.getMostSpecificKey(modifiers);
        return new StatInstance(value, op, key);
    }

    private static StatGearKey getMostSpecificKey(Collection<StatInstance> modifiers) {
        HashSet<StatGearKey> found = new HashSet<StatGearKey>();
        for (StatInstance mod : modifiers) {
            found.add(mod.key);
        }
        StatGearKey ret = null;
        int best = 0;
        for (StatGearKey key : found) {
            int parents = 0;
            StatGearKey parent = key.getParent();
            while (parent != null) {
                parent = parent.getParent();
                ++parents;
            }
            if (parents <= best && ret != null) continue;
            best = parents;
            ret = key;
        }
        return ret != null ? ret : DEFAULT_KEY;
    }

    public MutableComponent getFormattedText(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        switch (this.op) {
            case ADD: {
                return this.formatAdd(stat, decimalPlaces, addColor);
            }
            case AVG: {
                return this.formatAvg(stat, decimalPlaces, addColor);
            }
            case MAX: {
                return this.formatMax(stat, decimalPlaces, addColor);
            }
            case MUL1: {
                return this.formatMul1(stat, decimalPlaces, addColor);
            }
            case MUL2: {
                return this.formatMul2(stat, decimalPlaces, addColor);
            }
        }
        throw new NotImplementedException("Unknown operation: " + this.op);
    }

    private MutableComponent formatAdd(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s%." + decimalPlaces + "f";
        Color color = StatInstance.getFormattedColor(this.value, 0.0f, addColor);
        String text = StatInstance.trimNumber(String.format(format, this.value < 0.0f ? "" : "+", Float.valueOf(this.value)));
        return TextUtil.withColor((MutableComponent)new TextComponent(text), color);
    }

    private MutableComponent formatAvg(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        Object text;
        Color color = StatInstance.getFormattedColor(this.value, 0.0f, addColor);
        if (stat.getDisplayFormat() == ItemStat.DisplayFormat.PERCENTAGE) {
            text = Math.round(this.value * 100.0f) + "%";
        } else {
            String format = "%s%." + decimalPlaces + "f%s";
            String ret = StatInstance.trimNumber(String.format(format, "", Float.valueOf(this.value), ""));
            text = stat.getDisplayFormat() == ItemStat.DisplayFormat.MULTIPLIER ? ret + "x" : ret;
        }
        return TextUtil.withColor((MutableComponent)new TextComponent((String)text), color);
    }

    private MutableComponent formatMax(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s%." + decimalPlaces + "f";
        String text = StatInstance.trimNumber(String.format(format, "\u2191", Float.valueOf(this.value)));
        return TextUtil.withColor((MutableComponent)new TextComponent(text), Color.WHITE);
    }

    private MutableComponent formatMul1(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        int percent = Math.round(100.0f * this.value);
        Color color = StatInstance.getFormattedColor(percent, 0.0f, addColor);
        String text = StatInstance.trimNumber(String.format("%s%d%%", percent < 0 ? "" : "+", percent));
        return TextUtil.withColor((MutableComponent)new TextComponent(text), color);
    }

    private MutableComponent formatMul2(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s%." + decimalPlaces + "f";
        float val = 1.0f + this.value;
        Color color = StatInstance.getFormattedColor(val, 1.0f, addColor);
        String text = StatInstance.trimNumber(String.format(format, "x", Float.valueOf(val)));
        return TextUtil.withColor((MutableComponent)new TextComponent(text), color);
    }

    private static String trimNumber(CharSequence str) {
        String trimToInt = REGEX_TRIM_TO_INT.matcher(str).replaceFirst("");
        if (trimToInt.contains(".")) {
            return REGEX_REMOVE_TRAILING_ZEROS.matcher(trimToInt).replaceFirst("");
        }
        return trimToInt;
    }

    private static Color getFormattedColor(float val, float whiteVal, boolean addColor) {
        if (!addColor) {
            return Color.WHITE;
        }
        return val < whiteVal ? Color.INDIANRED : (MathUtils.floatsEqual((float)val, (float)whiteVal) ? Color.WHITE : Color.LIGHTGREEN);
    }

    public boolean shouldList(IGearPart part, ItemStat stat, boolean advanced) {
        return this.shouldList(part.getType(), stat, advanced);
    }

    public boolean shouldList(PartType partType, ItemStat stat, boolean advanced) {
        return advanced || this.value != 0.0f || partType == PartType.MAIN && stat == ItemStats.HARVEST_LEVEL;
    }

    public int getPreferredDecimalPlaces(ItemStat stat, int max) {
        return stat.isDisplayAsInt() && this.op != Operation.MUL1 && this.op != Operation.MUL2 ? 0 : 2;
    }

    public String toString() {
        return String.format("StatInstance{value=%.3f, op=%s, key=%s}", new Object[]{Float.valueOf(this.value), this.op, this.key});
    }

    public JsonElement serialize() {
        if (this.op == Operation.AVG) {
            return new JsonPrimitive((Number)Float.valueOf(this.value));
        }
        JsonObject json = new JsonObject();
        json.addProperty(this.op.name().toLowerCase(Locale.ROOT), (Number)Float.valueOf(this.value));
        return json;
    }

    public static StatInstance read(StatGearKey key, JsonElement json) {
        Operation defaultOp = key.getStat().getDefaultOperation();
        if (json.isJsonPrimitive()) {
            return new StatInstance(json.getAsFloat(), defaultOp, key);
        }
        if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            StatInstance result = StatInstance.readShorthandObject(key, jsonObj);
            if (result != null) {
                return result;
            }
            float value = GsonHelper.m_13820_((JsonObject)jsonObj, (String)"value", (float)0.0f);
            Operation op = jsonObj.has("op") ? Operation.byName(GsonHelper.m_13906_((JsonObject)jsonObj, (String)"op")) : defaultOp;
            return new StatInstance(value, op, key);
        }
        throw new JsonParseException("Expected stat modifier JSON to be float or object");
    }

    @Nullable
    private static StatInstance readShorthandObject(StatGearKey key, JsonObject json) {
        StatInstance result = null;
        for (Map.Entry entry : json.entrySet()) {
            Operation op = Operation.byNameOrNull((String)entry.getKey());
            if (op == null) continue;
            if (result == null) {
                result = new StatInstance(((JsonElement)entry.getValue()).getAsFloat(), op, key);
                continue;
            }
            throw new JsonParseException("Found multiple op keys in stat modifier object");
        }
        return result;
    }

    public static StatInstance read(@Nullable StatGearKey key, FriendlyByteBuf buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)buffer.m_130066_(Operation.class);
        return new StatInstance(value, op, key != null ? key : DEFAULT_KEY);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.value);
        buffer.m_130068_((Enum)this.op);
    }

    public static enum Operation {
        AVG,
        MAX,
        MUL1,
        MUL2,
        ADD;


        public static Operation byName(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return AVG;
        }

        @Nullable
        public static Operation byNameOrNull(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return null;
        }
    }
}

