/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.init.ModTags;

public class FluffyBlock
extends Block {
    private final DyeColor dyeColor;

    public FluffyBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60913_(0.8f, 3.0f).m_60918_(SoundType.f_56745_));
        this.dyeColor = color;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float distance) {
        int stackedBlocks;
        if (distance < 2.0f || world.f_46443_) {
            return;
        }
        for (stackedBlocks = 0; stackedBlocks < 10 && world.m_8055_(pos).m_60620_(ModTags.Blocks.FLUFFY_BLOCKS); ++stackedBlocks) {
            pos = pos.m_7495_();
        }
        float newDistance = distance - Math.min((float)(8 * stackedBlocks), distance);
        entity.f_19789_ = 0.0f;
        entity.m_142535_(newDistance, 1.0f, DamageSource.f_19315_);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(worldIn, entityIn);
        } else {
            FluffyBlock.bounceEntity(entityIn);
        }
    }

    private static void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * 0.5 * d0, vector3d.f_82481_);
        }
    }

    private static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack mainHand = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        if (!mainHand.m_41619_() && mainHand.m_41720_() instanceof ShearsItem) {
            int efficiency = EnchantmentHelper.m_44926_((LivingEntity)event.getPlayer());
            float speed = event.getNewSpeed() * 4.0f;
            if (efficiency > 0) {
                speed += (float)(efficiency * efficiency + 1);
            }
            event.setNewSpeed(speed);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(FluffyBlock::onGetBreakSpeed);
    }
}

