/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.GearApi;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TagUtils;
import net.silentchaos512.utils.MathUtils;

public class ChargerContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData fields;

    public ChargerContainer(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf data) {
        this(type, id, inv, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData((int)data.readByte()));
    }

    public ChargerContainer(MenuType<?> type, int id, Inventory inv, Container blockInv, ContainerData fields) {
        super(type, id);
        this.inventory = blockInv;
        this.fields = fields;
        ChargerContainer.m_38869_((Container)this.inventory, (int)3);
        this.m_38897_(new Slot(this.inventory, 0, 56, 23){

            public boolean m_5857_(ItemStack stack) {
                return GearApi.isMaterial(stack);
            }
        });
        this.m_38897_(new Slot(this.inventory, 1, 56, 46){

            public boolean m_5857_(ItemStack stack) {
                return TagUtils.containsSafe(ModTags.Items.STARLIGHT_CHARGER_CATALYSTS, (ItemStack)stack);
            }
        });
        this.m_38897_((Slot)new SlotOutputOnly(this.inventory, 2, 116, 35));
        InventoryUtils.createPlayerSlots((Inventory)inv, (int)8, (int)84).forEach(x$0 -> this.m_38897_((Slot)x$0));
        this.m_38884_(this.fields);
    }

    public static ChargerContainer createStarlightCharger(int id, Inventory inv, FriendlyByteBuf data) {
        return new ChargerContainer((MenuType)ModContainers.STARLIGHT_CHARGER.get(), id, inv, data);
    }

    public static ChargerContainer createStarlightCharger(int id, Inventory inv, Container blockInv, ContainerData fields) {
        return new ChargerContainer((MenuType)ModContainers.STARLIGHT_CHARGER.get(), id, inv, blockInv, fields);
    }

    public int getWorkProgress() {
        return this.fields.m_6413_(0);
    }

    public int getWorkTime() {
        return this.fields.m_6413_(1);
    }

    public int getStructureLevel() {
        return this.fields.m_6413_(2);
    }

    public int getCharge() {
        int upper = this.fields.m_6413_(4) & 0xFFFF;
        int lower = this.fields.m_6413_(3) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getMaxCharge() {
        int upper = this.fields.m_6413_(6) & 0xFFFF;
        int lower = this.fields.m_6413_(5) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getChargeMeterHeight() {
        int max = this.getMaxCharge();
        int clamped = MathUtils.clamp((int)this.getCharge(), (int)0, (int)max);
        return max > 0 ? 50 * clamped / max : 0;
    }

    public int getProgressArrowScale() {
        int progress = this.getWorkProgress();
        int workTime = this.getWorkTime();
        return progress != 0 && workTime > 0 ? progress * 24 / workTime : 0;
    }

    public boolean m_6875_(Player playerIn) {
        return this.inventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int size;
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int startPlayer = size = this.inventory.m_6643_();
            int endPlayer = size + 27;
            int startHotbar = size + 27;
            int endHotbar = size + 36;
            if (index == 2 ? !this.m_38903_(stack1, startPlayer, endHotbar, true) : (index >= size && this.inventory.m_7013_(0, stack1) ? !this.m_38903_(stack1, 0, 1, false) : (index >= size && this.inventory.m_7013_(1, stack1) ? !this.m_38903_(stack1, 1, 2, false) : (index >= startPlayer && index < endPlayer ? !this.m_38903_(stack1, startHotbar, endHotbar, false) : (index >= startHotbar && index < endHotbar ? !this.m_38903_(stack1, startPlayer, endPlayer, false) : !this.m_38903_(stack1, startPlayer, endHotbar, false)))))) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack1);
        }
        return stack;
    }
}

