/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.GearApi;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.INamedContainerExtraData;
import net.silentchaos512.gear.block.charger.ChargerContainer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialModifiers;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.init.ModBlockEntities;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class ChargerTileEntity
extends LockableSidedInventoryTileEntity
implements INamedContainerExtraData {
    static final int INVENTORY_SIZE = 3;
    private static final int UPDATE_FREQUENCY = TimeUtils.ticksFromSeconds((float)15.0f);
    private final ChargedMaterialModifier.Type materialModifier;
    @SyncVariable(name="Progress")
    private int progress = 0;
    @SyncVariable(name="WorkTime")
    private int workTime = 100;
    @SyncVariable(name="Charge")
    private int charge = 0;
    @SyncVariable(name="StructureLevel")
    private int structureLevel;
    private int updateTimer = 0;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return ChargerTileEntity.this.progress;
                }
                case 1: {
                    return ChargerTileEntity.this.workTime;
                }
                case 2: {
                    return ChargerTileEntity.this.structureLevel;
                }
                case 3: {
                    return ChargerTileEntity.this.charge & 0xFFFF;
                }
                case 4: {
                    return ChargerTileEntity.this.charge >> 16 & 0xFFFF;
                }
                case 5: {
                    return ChargerTileEntity.this.getMaxCharge() & 0xFFFF;
                }
                case 6: {
                    return ChargerTileEntity.this.getMaxCharge() >> 16 & 0xFFFF;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ChargerTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ChargerTileEntity.this.workTime = value;
                    break;
                }
                case 2: {
                    ChargerTileEntity.this.structureLevel = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public ChargerTileEntity(BlockEntityType<?> tileEntityTypeIn, ChargedMaterialModifier.Type materialModifier, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, 3, pos, state);
        this.materialModifier = materialModifier;
    }

    public static ChargerTileEntity createStarlightCharger(BlockPos pos, BlockState state) {
        return new ChargerTileEntity((BlockEntityType)ModBlockEntities.STARLIGHT_CHARGER.get(), MaterialModifiers.STARCHARGED, pos, state);
    }

    protected int getMaxCharge() {
        return (Integer)Config.Common.starlightChargerMaxCharge.get();
    }

    @Override
    public void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.fields.m_6499_());
    }

    protected int getWorkTime(ItemStack input) {
        IMaterialInstance material = GearApi.getMaterial(input);
        if (material != null) {
            return 100 * material.getTier();
        }
        return -1;
    }

    protected int getDrainRate(ItemStack input, int level) {
        return 150 + 50 * level * level;
    }

    protected int getChargingAgentTier(ItemStack catalyst) {
        return ChargerTileEntity.getStarlightChargerCatalystTier(catalyst);
    }

    public static int getStarlightChargerCatalystTier(ItemStack catalyst) {
        for (int i = ModTags.Items.STARLIGHT_CHARGER_TIERS.size() - 1; i >= 0; --i) {
            if (!catalyst.m_150922_((Tag)ModTags.Items.STARLIGHT_CHARGER_TIERS.get(i))) continue;
            return i + 1;
        }
        return 0;
    }

    protected int getMaterialChargeLevel(ItemStack stack) {
        return this.materialModifier.checkLevel(stack);
    }

    private static boolean canCharge(ItemStack stack) {
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        for (IMaterialModifier modifier : material.getModifiers()) {
            if (!(modifier instanceof ChargedMaterialModifier)) continue;
            return false;
        }
        return true;
    }

    protected void chargeMaterial(ItemStack output, int level) {
        Object mod = this.materialModifier.create(MaterialInstance.from(output), level);
        this.materialModifier.write(mod, output);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChargerTileEntity blockEntity) {
        blockEntity.gatherEnergy();
        if (++blockEntity.updateTimer > UPDATE_FREQUENCY) {
            if (blockEntity.checkStructureLevel()) {
                SilentGear.LOGGER.info("{}} at {}: structure level updated to {}", (Object)blockEntity.m_58900_().m_60734_().getRegistryName(), (Object)blockEntity.f_58858_, (Object)blockEntity.structureLevel);
            }
            blockEntity.updateTimer = 0;
        }
        ItemStack input = blockEntity.m_8020_(0);
        ItemStack catalyst = blockEntity.m_8020_(1);
        if (input.m_41619_() || catalyst.m_41619_() || !GearApi.isMaterial(input)) {
            return;
        }
        int currentLevel = blockEntity.getMaterialChargeLevel(input);
        if (currentLevel < blockEntity.structureLevel) {
            blockEntity.handleCharging(input, catalyst);
        } else if (blockEntity.progress > 0) {
            blockEntity.progress = 0;
            blockEntity.workTime = 100;
        }
    }

    protected void gatherEnergy() {
        assert (this.f_58857_ != null);
        if (this.charge < this.getMaxCharge() && this.f_58857_.m_46462_() && this.f_58857_.m_46861_(this.f_58858_.m_7494_())) {
            int newCharge = this.charge + (Integer)Config.Common.starlightChargerChargeRate.get();
            this.charge = newCharge < 0 || newCharge > this.getMaxCharge() ? this.getMaxCharge() : newCharge;
        }
    }

    private void handleCharging(ItemStack input, ItemStack catalyst) {
        assert (this.f_58857_ != null);
        int chargeLevel = this.getChargingAgentTier(catalyst);
        int drainRate = this.getDrainRate(input, chargeLevel);
        if (ChargerTileEntity.canCharge(input) && chargeLevel > this.getMaterialChargeLevel(input) && chargeLevel <= this.structureLevel && this.charge >= drainRate && this.wouldFitInOutputSlot(input, chargeLevel)) {
            ++this.progress;
            this.charge -= drainRate;
            this.workTime = this.getWorkTime(input);
            if (this.progress >= this.workTime) {
                if (this.m_8020_(2).m_41619_()) {
                    ItemStack output = input.m_41777_();
                    output.m_41764_(1);
                    this.chargeMaterial(output, chargeLevel);
                    this.m_6836_(2, output);
                } else {
                    this.m_8020_(2).m_41769_(1);
                }
                this.progress = 0;
                this.m_7407_(0, 1);
                this.m_7407_(1, 1);
            }
        }
    }

    private boolean wouldFitInOutputSlot(ItemStack input, int chargeTier) {
        ItemStack output = this.m_8020_(2);
        if (output.m_41619_()) {
            return true;
        }
        return output.m_41613_() < output.m_41741_() && input.m_41656_(output) && this.getMaterialChargeLevel(output) == chargeTier && ChargerTileEntity.getGrade(input) == ChargerTileEntity.getGrade(output);
    }

    private static MaterialGrade getGrade(ItemStack stack) {
        IMaterialInstance material = GearApi.getMaterial(stack);
        if (material != null) {
            return material.getGrade();
        }
        return MaterialGrade.NONE;
    }

    protected boolean checkStructureLevel() {
        int oldValue = this.structureLevel;
        this.structureLevel = MathUtils.min((int)this.getPillarLevel(this.f_58858_.m_5484_(Direction.NORTH, 3).m_5484_(Direction.WEST, 3)), (int)this.getPillarLevel(this.f_58858_.m_5484_(Direction.NORTH, 3).m_5484_(Direction.EAST, 3)), (int)this.getPillarLevel(this.f_58858_.m_5484_(Direction.SOUTH, 3).m_5484_(Direction.WEST, 3)), (int)this.getPillarLevel(this.f_58858_.m_5484_(Direction.SOUTH, 3).m_5484_(Direction.EAST, 3)));
        return this.structureLevel != oldValue;
    }

    protected int getPillarLevel(BlockPos pos) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(pos.m_6630_(2));
        if (state.m_60734_() == ModBlocks.CRIMSON_STEEL_BLOCK.get()) {
            return 1;
        }
        if (state.m_60734_() == ModBlocks.AZURE_ELECTRUM_BLOCK.get()) {
            return 2;
        }
        if (state.m_60734_() == ModBlocks.TYRIAN_STEEL_BLOCK.get()) {
            return 3;
        }
        return 0;
    }

    protected Component m_6820_() {
        return TextUtil.translate("container", "material_charger");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChargerContainer.createStarlightCharger(id, player, (Container)this, this.fields);
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index > 1;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return GearApi.isMaterial(stack);
        }
        if (index == 1) {
            return stack.m_150922_(ModTags.Items.STARLIGHT_CHARGER_CATALYSTS);
        }
        return false;
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundTag)tags);
    }

    public CompoundTag save(CompoundTag tags) {
        CompoundTag compoundTag = super.save(tags);
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundTag)compoundTag, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return compoundTag;
    }

    public CompoundTag m_5995_() {
        CompoundTag tags = super.m_5995_();
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }
}

