/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.init.ModBlockEntities;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class MetalPressTileEntity
extends LockableSidedInventoryTileEntity {
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    @SyncVariable(name="Progress")
    private int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return MetalPressTileEntity.this.progress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MetalPressTileEntity.this.progress = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public MetalPressTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.METAL_PRESS.get(), 2, pos, state);
    }

    @Nullable
    public PressingRecipe getRecipe() {
        if (this.f_58857_ == null || this.m_8020_(0).m_41619_()) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_(ModRecipes.PRESSING_TYPE, (Container)this, this.f_58857_).orElse(null);
    }

    private ItemStack getWorkOutput(@Nullable PressingRecipe recipe) {
        if (recipe != null) {
            return recipe.m_5874_((Container)this);
        }
        return ItemStack.f_41583_;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MetalPressTileEntity blockEntity) {
        PressingRecipe recipe = blockEntity.getRecipe();
        if (recipe != null) {
            blockEntity.doWork(recipe);
        } else {
            blockEntity.stopWork();
        }
    }

    private void doWork(PressingRecipe recipe) {
        assert (this.f_58857_ != null);
        ItemStack current = this.m_8020_(1);
        ItemStack output = this.getWorkOutput(recipe);
        if (!current.m_41619_()) {
            int newCount = current.m_41613_() + output.m_41613_();
            if (!InventoryUtils.canItemsStack((ItemStack)current, (ItemStack)output) || newCount > output.m_41741_()) {
                this.stopWork();
                return;
            }
        }
        if (this.progress < WORK_TIME) {
            ++this.progress;
        }
        if (this.progress >= WORK_TIME && !this.f_58857_.f_46443_) {
            this.finishWork(recipe, current);
        }
        this.sendUpdate((BlockState)this.m_58900_().m_61124_((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void stopWork() {
        this.progress = 0;
        this.sendUpdate((BlockState)this.m_58900_().m_61124_((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(false)));
    }

    private void finishWork(PressingRecipe recipe, ItemStack current) {
        ItemStack output = this.getWorkOutput(recipe);
        if (!current.m_41619_()) {
            current.m_41769_(output.m_41613_());
        } else {
            this.m_6836_(1, output);
        }
        this.progress = 0;
        this.m_7407_(0, 1);
    }

    private void sendUpdate(BlockState newState) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState oldState = this.f_58857_.m_8055_(this.f_58858_);
        if (oldState != newState) {
            this.f_58857_.m_7731_(this.f_58858_, newState, 3);
            this.f_58857_.m_7260_(this.f_58858_, oldState, newState, 3);
        }
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected Component m_6820_() {
        return TextUtil.translate("container", "metal_press");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new MetalPressContainer(id, player, (Container)this, this.fields);
    }

    void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.fields.m_6499_());
    }
}

