/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.network.Network;

@Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
public class KeyTracker {
    public static final KeyMapping DISPLAY_STATS = KeyTracker.createKeyBinding("displayStats", 341);
    public static final KeyMapping DISPLAY_TRAITS = KeyTracker.createKeyBinding("displayTraits", 340);
    public static final KeyMapping DISPLAY_CONSTRUCTION = KeyTracker.createKeyBinding("displayConstruction", 342);
    public static final KeyMapping OPEN_ITEM = KeyTracker.createKeyBinding("openItem", 88);
    public static final KeyMapping CYCLE_BACK = KeyTracker.createKeyBinding("cycle.back", 90);
    public static final KeyMapping CYCLE_NEXT = KeyTracker.createKeyBinding("cycle.next", 67);
    private static int materialCycleCount = 0;

    public static void register(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_BACK);
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_NEXT);
        ClientRegistry.registerKeyBinding((KeyMapping)DISPLAY_STATS);
        ClientRegistry.registerKeyBinding((KeyMapping)DISPLAY_TRAITS);
        ClientRegistry.registerKeyBinding((KeyMapping)DISPLAY_CONSTRUCTION);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_ITEM);
    }

    @Nonnull
    private static KeyMapping createKeyBinding(String description, int key) {
        return new KeyMapping("key.silentgear." + description, (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, key, "key.categories.silentgear");
    }

    public static int getMaterialCycleIndex(int total) {
        int i = materialCycleCount % total;
        return i < 0 ? i + total : i;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        ItemStack hovered;
        if (event.getAction() == 0 && event.getKey() == DISPLAY_STATS.getKey().m_84873_()) {
            materialCycleCount = 0;
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_NEXT.getKey().m_84873_()) {
            if (KeyTracker.isDisplayStatsDown()) {
                ++materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).m_41619_()) {
                Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.CYCLE_NEXT, KeyTracker.getHoveredSlot()));
            }
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_BACK.getKey().m_84873_()) {
            if (KeyTracker.isDisplayStatsDown()) {
                --materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).m_41619_()) {
                Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.CYCLE_BACK, KeyTracker.getHoveredSlot()));
            }
        }
        if (event.getAction() == 1 && event.getKey() == OPEN_ITEM.getKey().m_84873_() && !(hovered = KeyTracker.getHoveredItem()).m_41619_()) {
            Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.OPEN_ITEM, KeyTracker.getHoveredSlot()));
        }
    }

    private static ItemStack getHoveredItem() {
        AbstractContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.m_7993_();
        }
        return ItemStack.f_41583_;
    }

    private static int getHoveredSlot() {
        AbstractContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.f_40219_;
        }
        return -1;
    }

    public static boolean isDisplayStatsDown() {
        int code = DISPLAY_STATS.getKey().m_84873_();
        if (code == 341 || code == 345 || DISPLAY_STATS.m_90862_()) {
            return KeyTracker.isControlDown();
        }
        return DISPLAY_STATS.m_90857_();
    }

    public static boolean isDisplayConstructionDown() {
        int code = DISPLAY_CONSTRUCTION.getKey().m_84873_();
        if (code == 342 || code == 346 || DISPLAY_CONSTRUCTION.m_90862_()) {
            return KeyTracker.isAltDown();
        }
        return DISPLAY_CONSTRUCTION.m_90857_();
    }

    public static boolean isDisplayTraitsDown() {
        int code = DISPLAY_TRAITS.getKey().m_84873_();
        if (code == 340 || code == 344 || DISPLAY_TRAITS.m_90862_()) {
            return KeyTracker.isShiftDown();
        }
        return DISPLAY_TRAITS.m_90857_();
    }

    public static boolean isShiftDown() {
        long h = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)h, (int)340) || InputConstants.m_84830_((long)h, (int)344);
    }

    public static boolean isControlDown() {
        long h = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)h, (int)341) || InputConstants.m_84830_((long)h, (int)345);
    }

    public static boolean isAltDown() {
        long h = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)h, (int)342) || InputConstants.m_84830_((long)h, (int)346);
    }
}

