/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartDisplay;
import net.silentchaos512.gear.api.part.PartDisplay;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.model.fragment.FragmentModelLoader;
import net.silentchaos512.gear.client.model.gear.GearModelLoader;
import net.silentchaos512.gear.client.model.part.CompoundPartModelLoader;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.IEarlySelectiveReloadListener;
import net.silentchaos512.gear.util.TextUtil;
import org.apache.commons.io.IOUtils;

public final class GearDisplayManager
implements IEarlySelectiveReloadListener {
    public static final GearDisplayManager INSTANCE = new GearDisplayManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String PATH_MATERIALS = "silentgear_materials";
    private static final String PATH_PARTS = "silentgear_parts";
    private static final Map<ResourceLocation, IMaterialDisplay> MATERIALS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<ResourceLocation, IPartDisplay> PARTS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    private GearDisplayManager() {
    }

    @Override
    public void onResourceManagerReload(ResourceManager resourceManager) {
        CompoundPartModelLoader.clearCaches();
        FragmentModelLoader.clearCaches();
        GearModelLoader.clearCaches();
        ERROR_LIST.clear();
        GearDisplayManager.reloadMaterials(resourceManager);
        GearDisplayManager.reloadParts(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadMaterials(ResourceManager resourceManager) {
        Collection resources = resourceManager.m_6540_(PATH_MATERIALS, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            SilentGear.LOGGER.info("Reloading material model files");
            MATERIALS.clear();
            String packName = "ERROR";
            for (ResourceLocation id : resources) {
                String path = id.m_135815_().substring(PATH_MATERIALS.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                try {
                    Resource iresource = resourceManager.m_142591_(id);
                    try {
                        packName = iresource.m_7816_();
                        JsonObject json = (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error("Could not load material model {} as it's null or empty", (Object)name);
                            continue;
                        }
                        MaterialDisplay model = MaterialDisplay.deserialize(name, json);
                        MATERIALS.put(name, model);
                    }
                    finally {
                        if (iresource == null) continue;
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error("Parsing error loading material model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("material:%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error("Could not read material model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("material:%s (%s)", name, packName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadParts(ResourceManager resourceManager) {
        Collection resources = resourceManager.m_6540_(PATH_PARTS, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            SilentGear.LOGGER.info("Reloading part model files");
            PARTS.clear();
            String packName = "ERROR";
            for (ResourceLocation id : resources) {
                String path = id.m_135815_().substring(PATH_PARTS.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                try {
                    Resource iresource = resourceManager.m_142591_(id);
                    try {
                        packName = iresource.m_7816_();
                        JsonObject json = (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error("Could not load part model {} as it's null or empty", (Object)name);
                            continue;
                        }
                        PartDisplay model = PartDisplay.deserialize(name, json);
                        PARTS.put(name, model);
                    }
                    finally {
                        if (iresource == null) continue;
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error("Parsing error loading part model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("part:%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error("Could not read part model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("part:%s (%s)", name, packName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IMaterialDisplay> getMaterials() {
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            ArrayList<IMaterialDisplay> ret = new ArrayList<IMaterialDisplay>();
            for (IMaterial material : MaterialManager.getValues()) {
                MaterialInstance mat = MaterialInstance.of(material);
                ret.add(mat.getDisplayProperties());
            }
            ret.addAll(MATERIALS.values());
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IPartDisplay> getParts() {
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            return PARTS.values();
        }
    }

    @Nullable
    public static IMaterialDisplay get(IMaterialInstance material) {
        IMaterial mat = (IMaterial)material.get();
        if (mat != null) {
            IMaterialDisplay displayOverride = mat.getDisplayOverride(material);
            if (displayOverride != null) {
                return displayOverride;
            }
            return GearDisplayManager.get(mat);
        }
        return GearDisplayManager.getMaterial(material.getId());
    }

    @Deprecated
    @Nullable
    public static IMaterialDisplay get(IMaterial material) {
        return GearDisplayManager.getMaterial(material.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public static IMaterialDisplay getMaterial(ResourceLocation materialId) {
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            return MATERIALS.get(materialId);
        }
    }

    @Nullable
    public static IPartDisplay get(IGearPart part) {
        return GearDisplayManager.getPart(part.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IPartDisplay getPart(ResourceLocation partId) {
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            return PARTS.get(partId);
        }
    }

    public static Collection<Component> getErrorMessages(Player player) {
        ArrayList<Component> ret = new ArrayList<Component>();
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            ret.add((Component)TextUtil.withColor((MutableComponent)new TextComponent("[Silent Gear] The following part/material models failed to load, check your log file:"), ChatFormatting.RED));
            ret.add((Component)new TextComponent(listStr));
        }
        return ret;
    }
}

