/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IPartDisplay;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.GearDisplayManager;
import net.silentchaos512.gear.client.model.ModelErrorLogging;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.gear.GearModel;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.gear.GearCrossbowItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.utils.Color;

public class GearModelOverrideList
extends ItemOverrides {
    private final Cache<CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final GearModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ResourceLocation modelLocation;

    public GearModelOverrideList(GearModel model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    static boolean isDebugLoggingEnabled() {
        return (Boolean)Config.Common.modelAndTextureLogging.get();
    }

    @Nullable
    public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int p_173469_) {
        int animationFrame = GearModelOverrideList.getAnimationFrame(stack, worldIn, entityIn);
        CacheKey key = GearModelOverrideList.getKey(model, stack, worldIn, entityIn, animationFrame);
        try {
            return (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(key, stack, worldIn, entityIn, animationFrame));
        }
        catch (Exception e) {
            ModelErrorLogging.notifyOfException(e, "gear item");
            return model;
        }
    }

    private static int getAnimationFrame(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        return ((ICoreItem)stack.m_41720_()).getAnimationFrame(stack, world, entity);
    }

    private BakedModel getOverrideModel(CacheKey key, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int animationFrame) {
        boolean broken = GearHelper.isBroken(stack);
        if (GearModelOverrideList.isDebugLoggingEnabled()) {
            SilentGear.LOGGER.info("getOverrideModel for {} ({})", (Object)stack.m_41786_().getString(), (Object)(broken ? "broken" : "normal"));
            SilentGear.LOGGER.info("- model key {}", (Object)key.data);
        }
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        for (PartData part : GearModelOverrideList.getPartsInRenderOrder(stack)) {
            MaterialInstance mat;
            if (!((ICoreItem)stack.m_41720_()).hasTexturesFor(part.getType())) continue;
            GearModelOverrideList.addSimplePartLayers(layers, part, stack);
            if (!(part.get() instanceof CompoundPart) || (mat = CompoundPart.getPrimaryMaterial(part)) == null) continue;
            GearModelOverrideList.addWithBlendedColor(layers, part, mat, stack);
        }
        if (stack.m_41720_() instanceof GearCrossbowItem) {
            GearModelOverrideList.getCrossbowCharge(stack, worldIn, entityIn).ifPresent(layers::add);
        }
        return this.model.bake(stack, layers, animationFrame, "test", this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private static PartDataList getPartsInRenderOrder(ItemStack stack) {
        PartDataList unsorted = GearData.getConstructionParts(stack);
        PartDataList ret = PartDataList.of(new PartData[0]);
        ICoreItem item = (ICoreItem)stack.m_41720_();
        for (PartType partType : item.getRenderParts()) {
            ret.addAll((Collection<? extends PartData>)unsorted.getPartsOfType(partType));
        }
        for (PartData part : unsorted) {
            if (ret.contains(part)) continue;
            ret.add(part);
        }
        return ret;
    }

    private static void addWithBlendedColor(List<MaterialLayer> list, PartData part, MaterialInstance material, ItemStack stack) {
        IMaterialDisplay model = material.getDisplayProperties();
        GearType gearType = GearHelper.getType(stack);
        List<MaterialLayer> layers = model.getLayerList(gearType, part, (IMaterialInstance)material).getLayers();
        GearModelOverrideList.addColorBlendedLayers(list, part, stack, layers);
    }

    private static void addSimplePartLayers(List<MaterialLayer> list, PartData part, ItemStack stack) {
        IPartDisplay model = GearDisplayManager.get(part.get());
        if (model != null) {
            GearType gearType = GearHelper.getType(stack);
            List<MaterialLayer> layers = model.getLayers(gearType, part).getLayers();
            GearModelOverrideList.addColorBlendedLayers(list, part, stack, layers);
        }
    }

    private static void addColorBlendedLayers(List<MaterialLayer> list, PartData part, ItemStack stack, List<MaterialLayer> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            if ((layer.getColor() & 0xFFFFFF) < 0xFFFFFF) {
                int blendedColor = part.getColor(stack, i, 0);
                MaterialLayer coloredLayer = layer.withColor(blendedColor);
                list.add(coloredLayer);
                if (!GearModelOverrideList.isDebugLoggingEnabled()) continue;
                GearModelOverrideList.debugLogLayer(coloredLayer, Color.format((int)blendedColor));
                continue;
            }
            list.add(layer);
            if (!GearModelOverrideList.isDebugLoggingEnabled()) continue;
            GearModelOverrideList.debugLogLayer(layer, "colorless");
        }
    }

    private static void debugLogLayer(MaterialLayer layer, String colorStr) {
        String partTypeStr = layer.getPartType() != null ? SilentGear.shortenId(layer.getPartType().getName()) : "null type?";
        SilentGear.LOGGER.info("  - add layer {} ({}, {})", (Object)layer.getTextureId(), (Object)partTypeStr, (Object)colorStr);
    }

    private static Optional<MaterialLayer> getCrossbowCharge(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        ItemPropertyFunction chargedProperty = ItemProperties.m_117829_((Item)stack.m_41720_(), (ResourceLocation)new ResourceLocation("charged"));
        ItemPropertyFunction fireworkProperty = ItemProperties.m_117829_((Item)stack.m_41720_(), (ResourceLocation)new ResourceLocation("firework"));
        if (chargedProperty != null && fireworkProperty != null) {
            boolean firework;
            boolean charged = chargedProperty.m_141951_(stack, world, entity, 0) > 0.0f;
            boolean bl = firework = fireworkProperty.m_141951_(stack, world, entity, 0) > 0.0f;
            if (charged) {
                if (firework) {
                    return Optional.of(new MaterialLayer(PartTextures.CHARGED_FIREWORK, 0xFFFFFF));
                }
                return Optional.of(new MaterialLayer(PartTextures.CHARGED_ARROW, 0xFFFFFF));
            }
        }
        return Optional.empty();
    }

    private static CacheKey getKey(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int animationFrame) {
        String brokenSuffix = GearHelper.isBroken(stack) ? "broken" : "";
        String chargeSuffix = GearModelOverrideList.getCrossbowCharge(stack, world, entity).map(l -> ";" + l.getTextureId().m_135815_()).orElse("");
        return new CacheKey(model, GearData.getModelKey(stack, animationFrame) + brokenSuffix + chargeSuffix);
    }

    public void clearCache() {
        SilentGear.LOGGER.debug("Clearing model cache for {}", (Object)this.model.gearType);
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final BakedModel parent;
        final String data;

        CacheKey(BakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

