/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.part;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.StaticLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.material.GearDisplayManager;
import net.silentchaos512.gear.client.model.BakedPerspectiveModel;
import net.silentchaos512.gear.client.model.BakedWrapper;
import net.silentchaos512.gear.client.model.LayeredModel;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.part.CompoundPartModelOverrideList;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.utils.Color;

public class CompoundPartModel
extends LayeredModel<CompoundPartModel> {
    private static final ModResourceLocation PART_MARKER_TEXTURE = SilentGear.getId("part_marker");
    private final ItemTransforms cameraTransforms;
    final GearType gearType;
    final PartType partType;
    final String texturePath;
    private final List<ResourceLocation> extraLayers;
    private CompoundPartModelOverrideList overrideList;

    CompoundPartModel(ItemTransforms cameraTransforms, GearType gearType, PartType partType, String texturePath, List<ResourceLocation> extraLayers) {
        this.cameraTransforms = cameraTransforms;
        this.gearType = gearType;
        this.partType = partType;
        this.texturePath = texturePath;
        this.extraLayers = Collections.unmodifiableList(extraLayers);
    }

    public void clearCache() {
        if (this.overrideList != null) {
            this.overrideList.clearCache();
        }
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        this.overrideList = new CompoundPartModelOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public BakedModel bake(List<MaterialLayer> layers, String transformVariant, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrideList, ResourceLocation modelLocation) {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        Transformation rotation = modelTransform.m_6189_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((ModelState)modelTransform);
        for (i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            TextureAtlasSprite texture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, layer.getTexture(this.texturePath, 0)));
            builder.addAll(CompoundPartModel.getQuadsForSprite(i, texture, rotation, layer.getColor()));
        }
        if (layers.isEmpty()) {
            if (Const.Materials.EXAMPLE.isPresent()) {
                this.buildFakeModel(spriteGetter, (ImmutableList.Builder<BakedQuad>)builder, rotation, Const.Materials.EXAMPLE.get());
            } else {
                SilentGear.LOGGER.error("Example material is missing?");
                TextureAtlasSprite texture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, (ResourceLocation)SilentGear.getId("item/error")));
                builder.addAll(CompoundPartModel.getQuadsForSprite(0, texture, rotation, 0xFFFFFF));
            }
        }
        for (i = 0; i < this.extraLayers.size(); ++i) {
            ResourceLocation texture = this.extraLayers.get(i);
            builder.addAll(CompoundPartModel.getQuadsForSprite(layers.size() + i, spriteGetter.apply(new Material(InventoryMenu.f_39692_, new StaticLayer(texture).getTexture())), rotation, 0xFFFFFF));
        }
        builder.addAll(CompoundPartModel.getQuadsForSprite(layers.size(), spriteGetter.apply(new Material(InventoryMenu.f_39692_, new StaticLayer(PART_MARKER_TEXTURE).getTexture())), rotation, Color.LIGHTSKYBLUE.getColor()));
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transforms, overrideList, rotation.isIdentity(), owner.isSideLit(), this.getCameraTransforms(transformVariant));
    }

    private void buildFakeModel(Function<Material, TextureAtlasSprite> spriteGetter, ImmutableList.Builder<BakedQuad> builder, Transformation rotation, IMaterial material) {
        MaterialInstance mat = MaterialInstance.of(material);
        IMaterialDisplay model = mat.getDisplayProperties();
        MaterialLayer exampleMain = model.getLayerList(this.gearType, this.partType, (IMaterialInstance)mat).getFirstLayer();
        if (exampleMain != null) {
            builder.addAll(CompoundPartModel.getQuadsForSprite(0, spriteGetter.apply(new Material(InventoryMenu.f_39692_, exampleMain.getTexture(this.texturePath, 0))), rotation, exampleMain.getColor()));
        }
        builder.addAll(CompoundPartModel.getQuadsForSprite(0, spriteGetter.apply(new Material(InventoryMenu.f_39692_, new StaticLayer(PART_MARKER_TEXTURE).getTexture(this.gearType, 0))), rotation, 0xFFFFFF));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> ret = new HashSet<Material>();
        if (this.gearType == GearType.SHIELD) {
            return ret;
        }
        for (PartTextures tex : PartTextures.getTextures(this.gearType)) {
            ret.add(this.getTexture(tex.getTexture()));
        }
        for (IMaterialDisplay materialDisplay : GearDisplayManager.getMaterials()) {
            for (MaterialLayer layer : materialDisplay.getLayerList(this.gearType, this.partType, (IMaterialInstance)LazyMaterialInstance.of(materialDisplay.getMaterialId()))) {
                ret.add(this.getTexture(layer));
            }
        }
        for (ResourceLocation texture : this.extraLayers) {
            ret.add(this.getTexture(new StaticLayer(texture)));
        }
        ret.add(this.getTexture(new StaticLayer(PART_MARKER_TEXTURE)));
        ret.add(new Material(InventoryMenu.f_39692_, (ResourceLocation)SilentGear.getId("item/error")));
        if (CompoundPartModelOverrideList.isDebugLoggingEnabled()) {
            SilentGear.LOGGER.info("Textures for compound part model '{}'", (Object)PartGearKey.of(this.gearType, this.partType));
            for (Material mat : ret) {
                SilentGear.LOGGER.info("- {}", (Object)mat.m_119203_());
            }
        }
        return ret;
    }

    private Material getTexture(MaterialLayer layer) {
        return CompoundPartModel.getMaterial(layer.getTexture(this.texturePath, 0));
    }

    private Material getTexture(ResourceLocation tex) {
        String path = "item/" + this.texturePath + "/" + tex.m_135815_();
        ResourceLocation location = new ResourceLocation(tex.m_135827_(), path);
        return CompoundPartModel.getMaterial(location);
    }

    private static Material getMaterial(ResourceLocation tex) {
        return new Material(InventoryMenu.f_39692_, tex);
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    private ItemTransforms getCameraTransforms(String transformVariant) {
        return this.cameraTransforms;
    }
}

