/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.part;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.client.model.ModelErrorLogging;
import net.silentchaos512.gear.client.model.part.CompoundPartModel;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;

public class CompoundPartModelOverrideList
extends ItemOverrides {
    private final Cache<CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final CompoundPartModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ResourceLocation modelLocation;

    public CompoundPartModelOverrideList(CompoundPartModel model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    static boolean isDebugLoggingEnabled() {
        return (Boolean)Config.Common.modelAndTextureLogging.get();
    }

    @Nullable
    public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int p_173469_) {
        CacheKey key = CompoundPartModelOverrideList.getKey(model, stack, (Level)worldIn, entityIn);
        try {
            return (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, worldIn, entityIn));
        }
        catch (Exception e) {
            ModelErrorLogging.notifyOfException(e, "compound part");
            return model;
        }
    }

    private BakedModel getOverrideModel(ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn) {
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        PartData part = PartData.from(stack);
        MaterialInstance primaryMaterial = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && primaryMaterial != null) {
            this.addWithBlendedColor(layers, part, primaryMaterial, stack);
        }
        return this.model.bake(layers, "test", this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private void addWithBlendedColor(List<MaterialLayer> list, PartData part, MaterialInstance material, ItemStack stack) {
        IMaterialDisplay materialModel = material.getDisplayProperties();
        List<MaterialLayer> layers = materialModel.getLayerList(this.model.gearType, part, (IMaterialInstance)material).getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            if ((layer.getColor() & 0xFFFFFF) < 0xFFFFFF) {
                int blendedColor = part.getColor(stack, i, 0);
                list.add(new MaterialLayer(layer.getTextureId(), part.getType(), blendedColor, false));
                continue;
            }
            list.add(layer);
        }
    }

    private static CacheKey getKey(BakedModel model, ItemStack stack, @Nullable Level world, @Nullable LivingEntity entity) {
        return new CacheKey(model, CompoundPartItem.getModelKey(stack));
    }

    public void clearCache() {
        if (CompoundPartModelOverrideList.isDebugLoggingEnabled()) {
            SilentGear.LOGGER.debug("Clearing model cache for {}/{}", (Object)this.model.partType, (Object)this.model.gearType);
        }
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final BakedModel parent;
        final String data;

        CacheKey(BakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

