/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.gear.trait.condition.AndTraitCondition;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.Network;

public final class TraitsCommand {
    private static final SuggestionProvider<CommandSourceStack> TRAIT_ID_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82957_(TraitManager.getValues().stream().map(ITrait::getId), (SuggestionsBuilder)builder);
    private static final String TRAITS_DATA_PATH = "https://github.com/SilentChaos512/Silent-Gear/tree/1.18.x/src/generated/resources/data/silentgear/silentgear_traits/";

    private TraitsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgear_traits").then(Commands.m_82127_((String)"describe").then(Commands.m_82129_((String)"traitID", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(TRAIT_ID_SUGGESTIONS).executes(context -> TraitsCommand.runDescribe((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"traitID")))))).then(Commands.m_82127_((String)"dump_md").executes(TraitsCommand::runDumpMd))).then(Commands.m_82127_((String)"list").executes(TraitsCommand::runList)));
    }

    private static int runDescribe(CommandContext<CommandSourceStack> context, ResourceLocation traitId) {
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TranslatableComponent("command.silentgear.traits.traitNotFound", new Object[]{traitId}));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)trait.getDisplayName(0), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)trait.getDescription(1), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.silentgear.traits.maxLevel", new Object[]{trait.getMaxLevel()}), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Object: " + trait), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Serializer: " + trait.getSerializer()), true);
        return 1;
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = TraitManager.getValues().stream().map(trait -> trait.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(listStr), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Total: " + TraitManager.getValues().size()), true);
        return 1;
    }

    private static int runDumpMd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SilentGear.LOGGER.info("Send traits wiki dump packet to client {}", (Object)player.m_6302_());
        ClientOutputCommandPacket message = new ClientOutputCommandPacket(ClientOutputCommandPacket.Type.TRAITS, true);
        Network.channel.sendTo((Object)message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpMdClient() {
        Player player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("TraitsCommand#runDumpMcClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "traits_list.md";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.m_6352_((Component)new TextComponent("Could not create directory: " + output.getParent()), Util.f_137441_);
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            writer.write("# Traits\n\n");
            writer.write("Generated in-game by `sgear_traits dump_md` command on " + TraitsCommand.getCurrentDateTime() + "\n\n");
            writer.write("This data may or may not be accurate depending on the mod pack you are playing and the mods or data packs installed.\n\n");
            writer.write("## Data Sources\n\n");
            writer.write("The following mods and data packs have added traits to the output. Running the dump command yourself may produce different results.\n\n");
            writer.write(TraitsCommand.getDataSources() + "\n");
            writer.write("## Trait Types\n\n");
            writer.write("These are trait serializers. You can define custom instances of these types using data packs.\n");
            writer.write("Code for traits and their serializers can be found in `net.silentchaos512.gear.gear.trait`.\n\n");
            writer.write("Note that \"simple\" traits are often used where custom code is required.\n");
            writer.write("They are not especially useful when just defined by a data pack.\n\n");
            for (ITraitSerializer<?> serializer : TraitSerializers.getSerializers()) {
                String typeName = serializer instanceof SimpleTrait.Serializer ? ((SimpleTrait.Serializer)serializer).getTypeName() : "";
                writer.write("- `" + serializer.getName() + "`");
                if (!typeName.isEmpty()) {
                    writer.write(" _(" + typeName + ")_");
                }
                writer.write("\n");
            }
            writer.write("\n## List of Traits");
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(TraitManager.getKeys());
            ids.sort(Comparator.comparing(id -> Objects.requireNonNull(TraitManager.get(id)).getDisplayName(0).getString()));
            for (ResourceLocation id2 : ids) {
                Collection<String> wikiLines;
                ITrait trait = TraitManager.get(id2);
                assert (trait != null);
                writer.write("\n");
                writer.write("### " + TraitsCommand.getLinkToBuiltinTraitJson(id2, trait.getDisplayName(0).getString()) + "\n");
                writer.write("- " + trait.getDescription(0).getString() + "\n");
                String materialsWithTrait = TraitsCommand.getMaterialsWithTrait(trait);
                writer.write("- Found On:\n  - Materials: " + (materialsWithTrait.isEmpty() ? "Nothing" : materialsWithTrait) + "\n");
                String partsWithTrait = TraitsCommand.getPartsWithTrait(trait);
                if (!partsWithTrait.isEmpty()) {
                    writer.write("  - Parts: " + partsWithTrait + "\n");
                }
                if (!trait.getConditions().isEmpty()) {
                    AndTraitCondition condition = new AndTraitCondition(trait.getConditions().toArray(new ITraitCondition[0]));
                    writer.write("- Conditions: " + condition.getDisplayText().getString() + "\n");
                }
                writer.write("- ID: `" + id2 + "`\n");
                writer.write("- Type: `" + trait.getSerializer().getName() + "`\n");
                writer.write("- Max Level: " + trait.getMaxLevel() + "\n");
                Collection cancelsWithSet = trait.getCancelsWithSet().stream().map(s -> "`" + s + "`").collect(Collectors.toList());
                if (!cancelsWithSet.isEmpty()) {
                    writer.write("- Cancels With: " + String.join((CharSequence)", ", cancelsWithSet) + "\n");
                }
                if ((wikiLines = trait.getExtraWikiLines()).isEmpty()) continue;
                writer.write("- Extra Info:\n");
                for (String line : wikiLines) {
                    writer.write(line + "\n");
                }
            }
            writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MutableComponent fileNameText = new TextComponent(output.getAbsolutePath()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.m_6352_((Component)new TextComponent("Wrote to ").m_7220_((Component)fileNameText), Util.f_137441_);
        }
    }

    private static String getCurrentDateTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return formatter.format(now);
    }

    private static String getLinkToBuiltinTraitJson(ResourceLocation traitId, String text) {
        if ("silentgear".equals(traitId.m_135827_())) {
            return String.format("[%s](%s)", text, TRAITS_DATA_PATH + traitId.m_135815_() + ".json");
        }
        return text;
    }

    private static String getMaterialsWithTrait(ITrait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (IMaterial material : MaterialManager.getValues(false)) {
            MaterialInstance instance = MaterialInstance.of(material);
            ArrayList<PartType> typesWithTrait = new ArrayList<PartType>();
            block1: for (PartType partType : PartType.getValues()) {
                Collection<TraitInstance> traits = instance.getTraits(partType);
                for (TraitInstance inst : traits) {
                    if (!inst.getTrait().equals(trait) || !material.isVisible(partType)) continue;
                    typesWithTrait.add(partType);
                    continue block1;
                }
            }
            if (typesWithTrait.isEmpty()) continue;
            if (foundAny) {
                str.append(", ");
            }
            foundAny = true;
            str.append("**").append(instance.getDisplayName(PartType.MAIN).getString()).append("**").append(" _(").append(typesWithTrait.stream().map(pt -> pt.getDisplayName(0).getString()).collect(Collectors.joining(", "))).append(")_");
        }
        return str.toString();
    }

    private static String getPartsWithTrait(ITrait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (IGearPart part : PartManager.getValues()) {
            PartData partData = PartData.of(part);
            for (TraitInstance inst : partData.getTraits()) {
                if (!inst.getTrait().equals(trait) || !part.isVisible()) continue;
                if (foundAny) {
                    str.append(", ");
                }
                foundAny = true;
                str.append("**").append(partData.getDisplayName(ItemStack.f_41583_).getString()).append("**");
            }
        }
        return str.toString();
    }

    private static String getDataSources() {
        LinkedHashSet<String> sourceSet = new LinkedHashSet<String>();
        for (ITrait trait : TraitManager.getValues()) {
            sourceSet.add(trait.getId().m_135827_());
        }
        StringBuilder ret = new StringBuilder();
        for (String id : sourceSet) {
            ret.append("- ");
            Optional container = ModList.get().getModContainerById(id);
            if (container.isPresent()) {
                IModInfo modInfo = ((ModContainer)container.get()).getModInfo();
                ret.append(modInfo.getDisplayName()).append(" (").append(id).append(") ").append(modInfo.getVersion()).append("\n");
                continue;
            }
            ret.append(id);
        }
        return ret.toString();
    }
}

