/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.silentchaos512.gear.item.gear.GearElytraItem;
import net.silentchaos512.gear.util.GearHelper;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioGearItemCapability {
    public static ICapabilityProvider createProvider(ItemStack stack, Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes) {
        return new Provider(new CurioGearItemWrapper(stack, extraAttributes));
    }

    public static ICapabilityProvider createElytraProvider(final ItemStack stack, GearElytraItem item) {
        return new Provider(new CurioGearItemWrapper(stack, multimap -> item.addAttributes("back", stack, (Multimap<Attribute, AttributeModifier>)multimap, false)){

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity.f_19853_.f_46443_ || !ElytraItem.m_41140_((ItemStack)stack)) {
                    return;
                }
                Integer ticksFlying = (Integer)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingEntity, (String)"fallFlyTicks");
                if (ticksFlying != null && (ticksFlying + 1) % 20 == 0) {
                    stack.m_41622_(1, livingEntity, entity -> entity.m_21166_(EquipmentSlot.CHEST));
                }
            }
        });
    }

    public static ICapabilityProvider createProvider(CurioGearItemWrapper curio) {
        return new Provider(curio);
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(CurioGearItemWrapper curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }

    public static class CurioGearItemWrapper
    implements ICurio {
        private final ItemStack stack;
        private final Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes;

        private CurioGearItemWrapper() {
            this(ItemStack.f_41583_, multimap -> {});
        }

        private CurioGearItemWrapper(ItemStack stack, Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes) {
            this.stack = stack;
            this.extraAttributes = extraAttributes;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            GearHelper.inventoryTick(this.stack, slotContext.entity().f_19853_, (Entity)slotContext.entity(), -1, true);
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
            Multimap<Attribute, AttributeModifier> multimap = GearHelper.getAttributeModifiers(slotContext.identifier(), this.stack, (Multimap<Attribute, AttributeModifier>)HashMultimap.create(), false);
            this.extraAttributes.accept(multimap);
            return multimap;
        }

        public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
            return 0;
        }

        public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting) {
            return 0;
        }

        @Nonnull
        public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
            return ICurio.DropRule.ALWAYS_KEEP;
        }

        public boolean canEquipFromUse(SlotContext slotContext) {
            return true;
        }

        @Nonnull
        public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
            return new ICurio.SoundInfo(SoundEvents.f_11676_, 1.0f, 1.0f);
        }
    }
}

