/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.gamestages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import org.apache.commons.io.IOUtils;

public class GameStagesCompat
implements ResourceManagerReloadListener {
    public static final PreparableReloadListener INSTANCE = new GameStagesCompat();
    private static final Map<ResourceLocation, List<String>> PARTS = Collections.synchronizedMap(new HashMap());
    private static final Map<String, List<String>> GEAR_TYPES = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canCraft(IGearPart part, Player player) {
        Map<ResourceLocation, List<String>> map = PARTS;
        synchronized (map) {
            List<String> stages = PARTS.getOrDefault(part.getId(), Collections.emptyList());
            return GameStagesCompat.hasAnyStage(player, stages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canCraft(GearType gearType, Player player) {
        Map<String, List<String>> map = GEAR_TYPES;
        synchronized (map) {
            List<String> stages = GEAR_TYPES.getOrDefault(gearType.getName(), Collections.emptyList());
            return GameStagesCompat.hasAnyStage(player, stages);
        }
    }

    private static boolean hasAnyStage(Player player, Collection<String> stages) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.m_6540_("silentgear_gamestages", s -> s.endsWith(".json"));
        for (ResourceLocation id : resources) {
            JsonObject json;
            Resource iresource;
            Map<Object, List<String>> map;
            String path = id.m_135815_().substring("silentgear_gamestages".length() + 1, id.m_135815_().length() - ".json".length());
            ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
            if (name.equals((Object)SilentGear.getId("parts"))) {
                map = PARTS;
                synchronized (map) {
                    try {
                        iresource = resourceManager.m_142591_(id);
                        try {
                            json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                            if (json != null) {
                                PARTS.clear();
                                json.entrySet().forEach(entry -> PARTS.put(new ResourceLocation((String)entry.getKey()), GameStagesCompat.parseStages((JsonElement)entry.getValue())));
                            }
                        }
                        finally {
                            if (iresource != null) {
                                iresource.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            if (name.equals((Object)SilentGear.getId("gear_types"))) {
                map = GEAR_TYPES;
                synchronized (map) {
                    try {
                        iresource = resourceManager.m_142591_(id);
                        try {
                            json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                            if (json != null) {
                                GEAR_TYPES.clear();
                                json.entrySet().forEach(entry -> GEAR_TYPES.put((String)entry.getKey(), GameStagesCompat.parseStages((JsonElement)entry.getValue())));
                            }
                        }
                        finally {
                            if (iresource != null) {
                                iresource.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            SilentGear.LOGGER.info("Unknown game stages JSON file found: {}", (Object)id);
        }
    }

    private static List<String> parseStages(JsonElement json) {
        if (json.isJsonArray()) {
            ArrayList<String> list = new ArrayList<String>();
            json.getAsJsonArray().forEach(e -> list.add(e.getAsString()));
            return list;
        }
        return Collections.singletonList(json.getAsString());
    }
}

