/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.compounder.MetalAlloyerScreen;
import net.silentchaos512.gear.block.compounder.RecrystallizerScreen;
import net.silentchaos512.gear.block.compounder.RefabricatorScreen;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.compat.jei.CompoundingRecipeCategory;
import net.silentchaos512.gear.compat.jei.GearCraftingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.MaterialGraderRecipeCategory;
import net.silentchaos512.gear.compat.jei.SalvagingRecipeCategoryJei;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGear.getId("plugin/main");
    static final ResourceLocation GEAR_CRAFTING = SilentGear.getId("category/gear_crafting");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GearCraftingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO, "fabric", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO, "gem", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO, "metal", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new MaterialGraderRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingRecipeCategoryJei(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        for (RepairKitItem repairKitItem : Registration.getItems(RepairKitItem.class)) {
            String itemName = NameUtils.fromItem((ItemLike)repairKitItem).m_135815_();
            reg.addRecipes(Collections.singleton(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint"), "", new ItemStack((ItemLike)repairKitItem), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairKitItem}), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN)}))), VanillaRecipeCategoryUid.CRAFTING);
            reg.addRecipes(Collections.singleton(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint_frag"), "", new ItemStack((ItemLike)repairKitItem), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairKitItem}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.FRAGMENT}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.FRAGMENT}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.FRAGMENT})}))), VanillaRecipeCategoryUid.CRAFTING);
        }
        reg.addRecipes((Collection)recipeManager.m_44051_().stream().filter(SGearJeiPlugin::isGearCraftingRecipe).collect(Collectors.toList()), GEAR_CRAFTING);
        reg.addRecipes((Collection)recipeManager.m_44051_().stream().filter(r -> r.m_6671_() == ModRecipes.COMPOUNDING_FABRIC_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_FABRIC);
        reg.addRecipes((Collection)recipeManager.m_44051_().stream().filter(r -> r.m_6671_() == ModRecipes.COMPOUNDING_GEM_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_GEM);
        reg.addRecipes((Collection)recipeManager.m_44051_().stream().filter(r -> r.m_6671_() == ModRecipes.COMPOUNDING_METAL_TYPE).collect(Collectors.toList()), Const.COMPOUNDING_METAL);
        for (int i = 2; i <= 4; ++i) {
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.FABRIC_COMPOUNDER_INFO, i, new FabricCompoundingRecipe(SilentGear.getId("fabric_example_" + i)))), Const.COMPOUNDING_FABRIC);
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.GEM_COMPOUNDER_INFO, i, new GemCompoundingRecipe(SilentGear.getId("gem_example_" + i)))), Const.COMPOUNDING_GEM);
            reg.addRecipes(Collections.singleton(CompoundingRecipe.makeExample(Const.METAL_COMPOUNDER_INFO, i, new MetalCompoundingRecipe(SilentGear.getId("metal_example_" + i)))), Const.COMPOUNDING_METAL);
        }
        reg.addRecipes(Collections.singleton(new MaterialGraderRecipeCategory.GraderRecipe()), Const.GRADING);
        reg.addRecipes((Collection)recipeManager.m_44051_().stream().filter(r -> r.m_6671_() == ModRecipes.SALVAGING_TYPE).collect(Collectors.toList()), Const.SALVAGING);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (Item item2 : Registration.getItems(item -> item instanceof ICoreTool)) {
            SGearJeiPlugin.addInfoPage(reg, (ItemLike)item2);
        }
    }

    private static boolean isGearCraftingRecipe(Recipe<?> recipe) {
        RecipeSerializer serializer = recipe.m_7707_();
        return serializer == ModRecipes.SHAPED_GEAR.get() || serializer == ModRecipes.SHAPELESS_GEAR.get() || serializer == ModRecipes.COMPOUND_PART.get();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), new ResourceLocation[]{GEAR_CRAFTING});
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.REFABRICATOR), new ResourceLocation[]{Const.COMPOUNDING_FABRIC});
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.RECRYSTALLIZER), new ResourceLocation[]{Const.COMPOUNDING_GEM});
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.METAL_ALLOYER), new ResourceLocation[]{Const.COMPOUNDING_METAL});
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.MATERIAL_GRADER), new ResourceLocation[]{Const.GRADING});
        reg.addRecipeCatalyst(new ItemStack(ModBlocks.SALVAGER), new ResourceLocation[]{Const.SALVAGING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(RefabricatorScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_FABRIC});
        reg.addRecipeClickArea(RecrystallizerScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_GEM});
        reg.addRecipeClickArea(MetalAlloyerScreen.class, 90, 30, 28, 23, new ResourceLocation[]{Const.COMPOUNDING_METAL});
        reg.addRecipeClickArea(GraderScreen.class, 48, 30, 28, 23, new ResourceLocation[]{Const.GRADING});
        reg.addRecipeClickArea(SalvagerScreen.class, 30, 30, 28, 23, new ResourceLocation[]{Const.SALVAGING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)ModItems.FRAGMENT.get(), (stack, context) -> {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        });
        IIngredientSubtypeInterpreter customMaterials = (stack, context) -> {
            MaterialInstance material = CustomMaterialItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        };
        reg.registerSubtypeInterpreter((Item)ModItems.CUSTOM_GEM.get(), customMaterials);
        reg.registerSubtypeInterpreter((Item)ModItems.CUSTOM_INGOT.get(), customMaterials);
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.m_5456_().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new Component[]{new TranslatableComponent(key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<ItemLike> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new Component[]{new TranslatableComponent(key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(Objects.requireNonNull(item.m_5456_().getRegistryName()));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent(key)});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.m_135827_() + "." + name.m_135815_() + ".desc";
    }
}

