/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.block.salvager.SalvagerTileEntity;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;

public class SalvagingRecipeCategoryJei
implements IRecipeCategory<SalvagingRecipe> {
    private static final int GUI_START_X = 8;
    private static final int GUI_START_Y = 16;
    private static final int GUI_WIDTH = 106;
    private static final int GUI_HEIGHT = 53;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public SalvagingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SalvagerScreen.TEXTURE, 8, 16, 106, 53);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.SALVAGER));
        this.arrow = guiHelper.drawableBuilder(SalvagerScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.salvaging");
    }

    public ResourceLocation getUid() {
        return Const.SALVAGING;
    }

    public Class<? extends SalvagingRecipe> getRecipeClass() {
        return SalvagingRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SalvagingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ingredients.setOutputs(VanillaTypes.ITEM, new ArrayList<ItemStack>(recipe.getPossibleResults((Container)new SimpleContainer(SalvagerTileEntity.INVENTORY_SIZE))));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SalvagingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 18);
        for (int i = 1; i < 10; ++i) {
            int x = 18 * ((i - 1) % 3) + 61 - 8;
            int y = 18 * ((i - 1) / 3) + 16 - 16;
            itemStacks.init(i, false, x, y);
        }
        itemStacks.set(0, Arrays.asList(recipe.getIngredient().m_43908_()));
        List<ItemStack> results = recipe.getPossibleResults((Container)new SimpleContainer(1));
        for (int i = 0; i < 9 && i < results.size(); ++i) {
            itemStacks.set(i + 1, results.get(i));
        }
    }

    public void draw(SalvagingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 24, 18);
    }
}

