/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.lib.util.NameUtils;

public class CustomCompoundIngredient
extends Ingredient {
    private final CustomMaterialItem item;
    private final ResourceLocation material;

    protected CustomCompoundIngredient(CustomMaterialItem item, ResourceLocation materialId) {
        super(Stream.of(new Ingredient.ItemValue(item.create(LazyMaterialInstance.of(materialId)))));
        this.item = item;
        this.material = materialId;
    }

    public static CustomCompoundIngredient of(CustomMaterialItem item, IMaterial material) {
        return CustomCompoundIngredient.of(item, material.getId());
    }

    public static CustomCompoundIngredient of(CustomMaterialItem item, ResourceLocation materialId) {
        return new CustomCompoundIngredient(item, materialId);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_41720_().equals(this.item)) {
            return false;
        }
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        return material != null && material.getId().equals((Object)this.material);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("item", NameUtils.from((IForgeRegistryEntry)this.item).toString());
        json.addProperty("material", this.material.toString());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<CustomCompoundIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("custom_compound");

        public CustomCompoundIngredient parse(JsonObject json) {
            ResourceLocation itemId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            if (!(item instanceof CustomMaterialItem)) {
                throw new JsonParseException("Item '" + itemId + "' is not a CustomMaterialItem");
            }
            ResourceLocation materialId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"material"));
            return new CustomCompoundIngredient((CustomMaterialItem)item, materialId);
        }

        public CustomCompoundIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation itemId = buffer.m_130281_();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            if (!(item instanceof CustomMaterialItem)) {
                throw new JsonParseException("Item '" + itemId + "' is not a CustomMaterialItem");
            }
            ResourceLocation materialId = buffer.m_130281_();
            return new CustomCompoundIngredient((CustomMaterialItem)item, materialId);
        }

        public void write(FriendlyByteBuf buffer, CustomCompoundIngredient ingredient) {
            buffer.m_130085_(NameUtils.from((IForgeRegistryEntry)ingredient.item));
            buffer.m_130085_(ingredient.material);
        }
    }
}

