/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public final class GearPartIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType type;

    private GearPartIngredient(PartType type) {
        super(Stream.of(new Ingredient.Value[0]));
        this.type = type;
    }

    public static GearPartIngredient of(PartType type) {
        return new GearPartIngredient(type);
    }

    @Override
    public PartType getPartType() {
        return this.type;
    }

    @Override
    public Optional<Component> getJeiHint() {
        TextComponent typeText = new TextComponent(this.type.getShortName());
        MutableComponent text = TextUtil.withColor((MutableComponent)typeText, Color.GOLD);
        return Optional.of(TextUtil.translate("jei", "partType", text));
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        PartData part = PartData.from(stack);
        return part != null && part.getType().equals(this.type);
    }

    public ItemStack[] m_43908_() {
        List<IGearPart> parts = PartManager.getPartsOfType(this.type);
        if (!parts.isEmpty()) {
            return (ItemStack[])parts.stream().flatMap(part -> Stream.of(part.getIngredient().m_43908_())).filter(stack -> !stack.m_41619_()).toArray(ItemStack[]::new);
        }
        return super.m_43908_();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.type.getName().toString());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<GearPartIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("silentgear", "part_type");

        private Serializer() {
        }

        public GearPartIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation typeName = buffer.m_130281_();
            PartType type = PartType.get(typeName);
            if (type == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            return new GearPartIngredient(type);
        }

        public GearPartIngredient parse(JsonObject json) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            Object id = typeName.contains(":") ? new ResourceLocation(typeName) : SilentGear.getId(typeName);
            PartType type = PartType.get(id);
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            return new GearPartIngredient(type);
        }

        public void write(FriendlyByteBuf buffer, GearPartIngredient ingredient) {
            buffer.m_130085_(ingredient.type.getName());
        }
    }
}

