/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public final class PartMaterialIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType partType;
    private final GearType gearType;
    private final int minTier;
    private final int maxTier;
    private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();

    private PartMaterialIngredient(PartType partType, GearType gearType, int minTier, int maxTier) {
        super(Stream.of(new Ingredient.Value[0]));
        this.partType = partType;
        this.gearType = gearType;
        this.minTier = minTier;
        this.maxTier = maxTier;
    }

    public static PartMaterialIngredient of(PartType partType) {
        return PartMaterialIngredient.of(partType, GearType.TOOL);
    }

    public static PartMaterialIngredient of(PartType partType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, GearType.TOOL, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType) {
        return new PartMaterialIngredient(partType, gearType, 0, Integer.MAX_VALUE);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, gearType, 0, Integer.MAX_VALUE, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier) {
        return new PartMaterialIngredient(partType, gearType, minTier, maxTier);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier, IMaterialCategory ... categories) {
        PartMaterialIngredient ret = new PartMaterialIngredient(partType, gearType, minTier, maxTier);
        ret.categories.addAll(Arrays.asList(categories));
        return ret;
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<Component> getJeiHint() {
        MutableComponent text;
        if (!this.categories.isEmpty()) {
            TextComponent cats = new TextComponent(this.categories.stream().map(IMaterialCategory::getName).collect(Collectors.joining(", ")));
            text = TextUtil.withColor((MutableComponent)cats, Color.INDIANRED);
        } else {
            TextComponent any = new TextComponent("any");
            text = TextUtil.withColor((MutableComponent)any, Color.LIGHTGREEN);
        }
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        text.m_7220_((Component)TextUtil.misc("spaceBrackets", key.toString()).m_130940_(ChatFormatting.GRAY));
        return Optional.of(TextUtil.translate("jei", "materialType", text));
    }

    public Set<IMaterialCategory> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        int tier = material.getTier(this.partType);
        return material.get().isCraftingAllowed(material, this.partType, this.gearType) && (this.categories.isEmpty() || material.hasAnyCategory(this.categories)) && this.tierMatches(tier);
    }

    private boolean tierMatches(int tier) {
        return tier >= this.minTier && tier <= this.maxTier;
    }

    public ItemStack[] m_43908_() {
        List<IMaterial> materials = MaterialManager.getValues();
        if (!materials.isEmpty()) {
            return (ItemStack[])materials.stream().map(MaterialInstance::of).filter(mat -> mat.get().isCraftingAllowed(mat, this.partType, this.gearType)).filter(mat -> this.categories.isEmpty() || mat.hasAnyCategory(this.categories)).filter(mat -> this.tierMatches(mat.getTier(this.partType))).flatMap(mat -> Stream.of(mat.get().getIngredient().m_43908_())).filter(stack -> !stack.m_41619_()).toArray(ItemStack[]::new);
        }
        return super.m_43908_();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.partType.getName().toString());
        if (this.gearType != GearType.TOOL) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        if (!this.categories.isEmpty()) {
            JsonArray array = new JsonArray();
            this.categories.forEach(cat -> array.add(cat.getName()));
            json.add("categories", (JsonElement)array);
        }
        if (this.minTier > 0) {
            json.addProperty("min_tier", (Number)this.minTier);
        }
        if (this.maxTier < Integer.MAX_VALUE) {
            json.addProperty("max_tier", (Number)this.maxTier);
        }
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<PartMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("material");

        private Serializer() {
        }

        public PartMaterialIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation typeName = buffer.m_130281_();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.m_130277_());
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            int categoryCount = buffer.readByte();
            IMaterialCategory[] categories = new IMaterialCategory[categoryCount];
            for (int i = 0; i < categoryCount; ++i) {
                categories[i] = MaterialCategories.get(buffer.m_130277_());
            }
            int minTier = buffer.m_130242_();
            int maxTier = buffer.m_130242_();
            return PartMaterialIngredient.of(partType, gearType, minTier, maxTier, categories);
        }

        public PartMaterialIngredient parse(JsonObject json) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = GsonHelper.m_13851_((JsonObject)json, (String)"gear_type", (String)"tool");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            ArrayList<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
            if (json.has("categories")) {
                JsonArray array = json.getAsJsonArray("categories");
                for (JsonElement element : array) {
                    categories.add(MaterialCategories.get(element.getAsString()));
                }
            }
            int minTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)0);
            int maxTier = GsonHelper.m_13824_((JsonObject)json, (String)"max_tier", (int)Integer.MAX_VALUE);
            PartMaterialIngredient ret = PartMaterialIngredient.of(type, gearType, minTier, maxTier);
            ret.categories.addAll(categories);
            return ret;
        }

        public void write(FriendlyByteBuf buffer, PartMaterialIngredient ingredient) {
            buffer.m_130085_(ingredient.partType.getName());
            buffer.m_130070_(ingredient.gearType.getName());
            buffer.writeByte(ingredient.categories.size());
            ingredient.categories.forEach(cat -> buffer.m_130070_(cat.getName()));
            buffer.m_130130_(ingredient.minTier);
            buffer.m_130130_(ingredient.maxTier);
        }
    }
}

