/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class QuickRepairRecipe
extends CustomRecipe {
    public QuickRepairRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack gear = ItemStack.f_41583_;
        boolean foundKit = false;
        float repairKitEfficiency = ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICoreItem) {
                if (!gear.m_41619_()) {
                    return false;
                }
                gear = stack;
                continue;
            }
            if (stack.m_41720_() instanceof RepairKitItem) {
                if (foundKit) {
                    return false;
                }
                foundKit = true;
                repairKitEfficiency = QuickRepairRecipe.getKitEfficiency(stack);
                continue;
            }
            if (MaterialManager.from(stack) != null) {
                materials.add(stack);
                continue;
            }
            return false;
        }
        if (gear.m_41619_() || (double)repairKitEfficiency < 1.0E-10) {
            return false;
        }
        for (ItemStack stack : materials) {
            if (ModRecipes.isRepairMaterial(gear, stack)) continue;
            return false;
        }
        return true;
    }

    private static float getKitEfficiency(ItemStack stack) {
        if (stack.m_41720_() instanceof RepairKitItem) {
            return ((RepairKitItem)stack.m_41720_()).getRepairEfficiency(RepairContext.Type.QUICK);
        }
        return ((Double)Config.Common.missingRepairKitEfficiency.get()).floatValue();
    }

    public ItemStack assemble(CraftingContainer inv) {
        RepairKitItem item;
        int value;
        StackList list = StackList.from((Container)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class).m_41777_();
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class);
        Collection mats = list.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat));
        QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, mats);
        if (gear.m_41773_() > 0 && repairKit.m_41720_() instanceof RepairKitItem && (value = (item = (RepairKitItem)repairKit.m_41720_()).getDamageToRepair(gear, repairKit, RepairContext.Type.QUICK)) > 0) {
            gear.m_41721_(gear.m_41773_() - Math.round(value));
        }
        GearData.incrementRepairCount(gear, 1);
        GearData.recalculateStats(gear, ForgeHooks.getCraftingPlayer());
        return gear;
    }

    private static void repairWithLooseMaterials(ItemStack gear, ItemStack repairKit, Collection<ItemStack> mats) {
        float repairValue = QuickRepairRecipe.getRepairValueFromMaterials(gear, mats);
        float kitEfficiency = QuickRepairRecipe.getKitEfficiency(repairKit);
        float gearRepairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY);
        gear.m_41721_(gear.m_41773_() - Math.round(repairValue * kitEfficiency * gearRepairEfficiency));
    }

    private static float getRepairValueFromMaterials(ItemStack gear, Collection<ItemStack> mats) {
        float repairEfficiency;
        float repairValue = 0.0f;
        for (ItemStack stack : mats) {
            MaterialInstance material = MaterialInstance.from(stack);
            if (material == null) continue;
            repairValue += (float)material.getRepairValue(gear);
        }
        if (gear.m_41720_() instanceof ICoreItem && (repairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY)) > 0.0f) {
            repairValue *= repairEfficiency;
        }
        return repairValue;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        StackList stackList = StackList.from((Container)inv);
        ItemStack gear = stackList.uniqueMatch(s -> s.m_41720_() instanceof ICoreItem);
        ItemStack repairKit = stackList.uniqueMatch(s -> s.m_41720_() instanceof RepairKitItem);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() instanceof RepairKitItem) {
                QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, stackList.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat)));
                RepairKitItem item = (RepairKitItem)stack.m_41720_();
                ItemStack copy = stack.m_41777_();
                item.removeRepairMaterials(copy, item.getRepairMaterials(gear, copy, RepairContext.Type.QUICK));
                list.set(i, (Object)copy);
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation m_6423_() {
        return Const.QUICK_REPAIR;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.QUICK_REPAIR.get();
    }

    public static final class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<QuickRepairRecipe> {
        public QuickRepairRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new QuickRepairRecipe(recipeId);
        }

        public QuickRepairRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new QuickRepairRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, QuickRepairRecipe recipe) {
        }
    }
}

