/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import java.util.Collection;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.crafting.recipe.IGearRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ShapelessGearRecipe
extends ExtendedShapelessRecipe
implements IGearRecipe {
    private final ICoreItem item;
    private final Lazy<ItemStack> exampleOutput;

    public ShapelessGearRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.m_8043_();
        if (!(output.m_41720_() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.m_41720_();
        this.exampleOutput = Lazy.of(() -> {
            ItemStack result = this.item.construct(GearHelper.getExamplePartsFromRecipe(this.item.getGearType(), (Iterable<Ingredient>)this.m_7527_()));
            GearData.setExampleTag(result, true);
            return result;
        });
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SHAPELESS_GEAR.get();
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!this.getBaseRecipe().m_5818_(inv, worldIn)) {
            return false;
        }
        GearType gearType = this.item.getGearType();
        Collection parts = this.getParts((Container)inv);
        if (parts.isEmpty()) {
            return false;
        }
        for (PartData part : parts) {
            if (part.isCraftingAllowed(gearType, inv)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        return this.item.construct(this.getParts((Container)inv));
    }

    @Override
    public ICoreItem getOutputItem() {
        return this.item;
    }

    public ItemStack m_8043_() {
        return (ItemStack)this.exampleOutput.get();
    }

    public boolean m_5598_() {
        return true;
    }
}

