/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;

public class ModBlockLootTables
extends BlockLoot {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45069_((Tag)Tags.Items.SHEARS));
    private static final LootItemCondition.Builder SILK_TOUCH_OR_SHEARS = SHEARS.m_7818_(SILK_TOUCH);
    private static final LootItemCondition.Builder NOT_SILK_TOUCH_OR_SHEARS = SILK_TOUCH_OR_SHEARS.m_81807_();

    protected void addTables() {
        this.m_124165_((Block)ModBlocks.BORT_ORE.get(), ModBlockLootTables.m_124139_((Block)((Block)ModBlocks.BORT_ORE.get()), (Item)CraftingItems.BORT.m_5456_()));
        this.m_124165_((Block)ModBlocks.DEEPSLATE_BORT_ORE.get(), ModBlockLootTables.m_124139_((Block)((Block)ModBlocks.DEEPSLATE_BORT_ORE.get()), (Item)CraftingItems.BORT.m_5456_()));
        this.m_124165_((Block)ModBlocks.CRIMSON_IRON_ORE.get(), ModBlockLootTables.m_124139_((Block)((Block)ModBlocks.CRIMSON_IRON_ORE.get()), (Item)CraftingItems.RAW_CRIMSON_IRON.m_5456_()));
        this.m_124165_((Block)ModBlocks.AZURE_SILVER_ORE.get(), ModBlockLootTables.m_124139_((Block)((Block)ModBlocks.AZURE_SILVER_ORE.get()), (Item)CraftingItems.RAW_AZURE_SILVER.m_5456_()));
        this.m_124288_((Block)ModBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.m_124288_((Block)ModBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.m_124288_((Block)ModBlocks.BLAZE_GOLD_BLOCK.get());
        this.m_124288_((Block)ModBlocks.BORT_BLOCK.get());
        this.m_124288_((Block)ModBlocks.CRIMSON_IRON_BLOCK.get());
        this.m_124288_((Block)ModBlocks.CRIMSON_STEEL_BLOCK.get());
        this.m_124288_((Block)ModBlocks.AZURE_SILVER_BLOCK.get());
        this.m_124288_((Block)ModBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.m_124288_((Block)ModBlocks.TYRIAN_STEEL_BLOCK.get());
        this.m_124288_((Block)ModBlocks.MATERIAL_GRADER.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_FENCE.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_FENCE_GATE.get());
        this.m_124175_((Block)ModBlocks.NETHERWOOD_LEAVES.get(), ModBlockLootTables.netherwoodLeaves(ModBlocks.NETHERWOOD_SAPLING, CraftingItems.NETHERWOOD_STICK, DEFAULT_SAPLING_DROP_RATES));
        this.m_124288_((Block)ModBlocks.NETHERWOOD_LOG.get());
        this.m_124288_((Block)ModBlocks.STRIPPED_NETHERWOOD_LOG.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_WOOD.get());
        this.m_124288_((Block)ModBlocks.STRIPPED_NETHERWOOD_WOOD.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_PLANKS.get());
        this.m_124288_((Block)ModBlocks.NETHERWOOD_SAPLING.get());
        this.m_124175_((Block)ModBlocks.NETHERWOOD_DOOR.get(), block -> ModBlockLootTables.m_124161_((Block)block, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
        this.m_124288_((Block)ModBlocks.NETHERWOOD_TRAPDOOR.get());
        this.m_124175_((Block)ModBlocks.NETHERWOOD_SLAB.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
        this.m_124288_((Block)ModBlocks.NETHERWOOD_STAIRS.get());
        this.m_124288_((Block)ModBlocks.STONE_TORCH.get());
        this.m_124165_((Block)ModBlocks.PHANTOM_LIGHT.get(), ModBlockLootTables.m_124125_());
        this.m_124252_((Block)ModBlocks.POTTED_NETHERWOOD_SAPLING.get());
        this.m_124288_((Block)ModBlocks.GEAR_SMITHING_TABLE.get());
        this.m_124288_((Block)ModBlocks.METAL_ALLOYER.get());
        this.m_124288_((Block)ModBlocks.METAL_PRESS.get());
        this.m_124288_((Block)ModBlocks.RECRYSTALLIZER.get());
        this.m_124288_((Block)ModBlocks.REFABRICATOR.get());
        this.m_124288_((Block)ModBlocks.SALVAGER.get());
        this.m_124288_((Block)ModBlocks.STARLIGHT_CHARGER.get());
        this.m_124288_((Block)ModBlocks.WHITE_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.LIME_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.PINK_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.GRAY_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.CYAN_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.BLUE_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.BROWN_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.GREEN_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.RED_FLUFFY_BLOCK.get());
        this.m_124288_((Block)ModBlocks.BLACK_FLUFFY_BLOCK.get());
        this.m_124165_((Block)ModBlocks.FLAX_PLANT.get(), ModBlockLootTables.flaxPlant((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.FLAX_PLANT.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))));
        this.m_124147_((Block)ModBlocks.WILD_FLAX_PLANT.get(), (ItemLike)ModItems.FLAX_SEEDS);
        this.m_124165_((Block)ModBlocks.FLUFFY_PLANT.get(), ModBlockLootTables.fluffyPlant((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModBlocks.FLUFFY_PLANT.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))));
        this.m_124147_((Block)ModBlocks.WILD_FLUFFY_PLANT.get(), (ItemLike)ModItems.FLUFFY_SEEDS);
    }

    @Nonnull
    private static Function<Block, LootTable.Builder> netherwoodLeaves(ItemLike sapling, ItemLike stick, float ... chances) {
        return block -> ModBlockLootTables.m_124171_((Block)block, (LootItemCondition.Builder)SILK_TOUCH_OR_SHEARS, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)ModBlockLootTables.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(NOT_SILK_TOUCH_OR_SHEARS).m_79076_(((LootPoolSingletonContainer.Builder)ModBlockLootTables.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)stick).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(NOT_SILK_TOUCH_OR_SHEARS).m_79076_(((LootPoolSingletonContainer.Builder)ModBlockLootTables.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_(ModItems.NETHER_BANANA))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    private static LootTable.Builder flaxPlant(LootItemCondition.Builder builder) {
        return (LootTable.Builder)ModBlockLootTables.m_124131_(ModBlocks.FLAX_PLANT, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CraftingItems.FLAX_FIBER).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).m_79161_(LootPool.m_79043_().m_6509_(builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(ModItems.FLAX_SEEDS).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).m_79161_(LootPool.m_79043_().m_6509_(builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CraftingItems.FLAX_FLOWERS).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5f, (int)1)))));
    }

    private static LootTable.Builder fluffyPlant(LootItemCondition.Builder builder) {
        return (LootTable.Builder)ModBlockLootTables.m_124131_(ModBlocks.FLUFFY_PLANT, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CraftingItems.FLUFFY_PUFF).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).m_79161_(LootPool.m_79043_().m_6509_(builder).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(ModItems.FLUFFY_SEEDS).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "silentgear".equals(block.getRegistryName().m_135827_())).collect(Collectors.toSet());
    }
}

