/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.LazyItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.api.traits.LazyTraitInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.gear.part.PartTextureSet;
import net.silentchaos512.gear.util.DataResource;

public class MaterialBuilder {
    final ResourceLocation id;
    private final int tier;
    private boolean canSalvage = true;
    private final Ingredient ingredient;
    private final Map<PartType, Ingredient> partSubstitutes = new LinkedHashMap<PartType, Ingredient>();
    private boolean visible = true;
    private Collection<String> gearBlacklist = new ArrayList<String>();
    private final Collection<ICondition> loadConditions = new ArrayList<ICondition>();
    @Nullable
    private ResourceLocation parent;
    private final Collection<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
    private Component name;
    @Nullable
    private Component namePrefix;
    private IMaterialSerializer<?> serializer = MaterialSerializers.STANDARD;
    private boolean simple = true;
    private final Map<PartType, StatModifierMap> stats = new LinkedHashMap<PartType, StatModifierMap>();
    private final Map<PartType, List<ITraitInstance>> traits = new LinkedHashMap<PartType, List<ITraitInstance>>();
    private final Map<PartGearKey, MaterialLayerList> display = new LinkedHashMap<PartGearKey, MaterialLayerList>();
    private boolean hasModels = true;

    public MaterialBuilder(ResourceLocation id, int tier, ResourceLocation ingredientTagName) {
        this(id, tier, Ingredient.m_43911_((Tag)ItemTags.m_13194_((String)ingredientTagName.toString())));
    }

    public MaterialBuilder(ResourceLocation id, int tier, Tag<Item> ingredient) {
        this(id, tier, Ingredient.m_43911_(ingredient));
    }

    public MaterialBuilder(ResourceLocation id, int tier, ItemLike ... ingredients) {
        this(id, tier, Ingredient.m_43929_((ItemLike[])ingredients));
    }

    public MaterialBuilder(ResourceLocation id, int tier, Ingredient ingredient) {
        this.id = id;
        this.tier = tier;
        this.ingredient = ingredient;
        this.name = new TranslatableComponent(String.format("material.%s.%s", this.id.m_135827_(), this.id.m_135815_().replace("/", ".")));
    }

    public MaterialBuilder type(IMaterialSerializer<?> serializer, boolean simple) {
        this.serializer = serializer;
        this.simple = simple;
        return this;
    }

    public MaterialBuilder loadConditionTagExists(ResourceLocation tagId) {
        return this.loadCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tagId)));
    }

    public MaterialBuilder loadCondition(ICondition condition) {
        this.loadConditions.add(condition);
        return this;
    }

    public MaterialBuilder parent(ResourceLocation parent) {
        this.parent = parent;
        return this;
    }

    public MaterialBuilder categories(IMaterialCategory ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public MaterialBuilder canSalvage(boolean value) {
        this.canSalvage = value;
        return this;
    }

    public MaterialBuilder partSubstitute(PartType partType, ItemLike item) {
        return this.partSubstitute(partType, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MaterialBuilder partSubstitute(PartType partType, Tag<Item> tag) {
        return this.partSubstitute(partType, Ingredient.m_43911_(tag));
    }

    public MaterialBuilder partSubstitute(PartType partType, Ingredient ingredient) {
        this.partSubstitutes.put(partType, ingredient);
        return this;
    }

    public MaterialBuilder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public MaterialBuilder blacklistGearType(GearType gearType) {
        return this.blacklistGearType(gearType.getName());
    }

    public MaterialBuilder blacklistGearType(String gearType) {
        this.gearBlacklist.add(gearType);
        return this;
    }

    public MaterialBuilder name(Component text) {
        this.name = text;
        return this;
    }

    public MaterialBuilder namePrefix(Component text) {
        this.namePrefix = text;
        return this;
    }

    public MaterialBuilder displayAll(PartTextureSet texture, int color) {
        if (this.stats.isEmpty()) {
            throw new IllegalStateException("Must build stats map first!");
        }
        for (PartType partType : this.stats.keySet()) {
            PartTextureSet targetTexture;
            PartTextureSet partTextureSet = targetTexture = texture == PartTextureSet.HIGH_CONTRAST_WITH_HIGHLIGHT && partType != PartType.MAIN ? PartTextureSet.HIGH_CONTRAST : texture;
            if (partType == PartType.ADORNMENT) {
                this.displayAdornment(targetTexture, color);
                continue;
            }
            if (partType == PartType.CORD) {
                this.displayBowstring(color);
                continue;
            }
            if (partType == PartType.TIP) {
                this.displayTip(targetTexture.getLayers(partType).get(0), color);
                continue;
            }
            if (partType == PartType.COATING) {
                this.displayCoating(targetTexture, color);
                continue;
            }
            if (partType == PartType.LINING) {
                this.displayLining(targetTexture, color);
                continue;
            }
            this.display(partType, targetTexture, color);
        }
        return this;
    }

    public MaterialBuilder displayAdornment(PartTextureSet textures, int color) {
        this.display(PartType.ADORNMENT, GearType.ALL, new MaterialLayerList(PartType.ADORNMENT, textures, color));
        this.display(PartType.ADORNMENT, GearType.PART, new MaterialLayer(SilentGear.getId("adornment"), color), new MaterialLayer(SilentGear.getId("adornment_highlight"), 0xFFFFFF));
        return this;
    }

    public MaterialBuilder displayBowstring(int color) {
        this.display(PartType.CORD, new MaterialLayer(PartTextures.BOWSTRING_STRING, color), new MaterialLayer(PartTextures.ARROW, 0xFFFFFF));
        this.display(PartType.CORD, GearType.PART, new MaterialLayer(SilentGear.getId("bowstring"), color));
        return this;
    }

    public MaterialBuilder displayCoating(PartTextureSet textures, int color) {
        this.display(PartType.COATING, GearType.ALL, new MaterialLayerList(PartType.MAIN, textures, color));
        this.display(PartType.COATING, GearType.PART, new MaterialLayer(SilentGear.getId("coating_material"), color), new MaterialLayer(SilentGear.getId("coating_jar"), 0xFFFFFF));
        return this;
    }

    public MaterialBuilder displayLining(PartTextureSet textures, int color) {
        this.display(PartType.LINING, GearType.PART, new MaterialLayerList(PartType.LINING, textures, color));
        return this;
    }

    public MaterialBuilder displayMain(PartTextureSet textures, int color) {
        return this.display(PartType.MAIN, GearType.ALL, new MaterialLayerList(PartType.MAIN, textures, color));
    }

    public MaterialBuilder displayTip(PartTextures texture, int color) {
        this.display(PartType.TIP, GearType.ALL, new MaterialLayer(texture, color));
        this.display(PartType.TIP, GearType.PART, new MaterialLayer(SilentGear.getId("tip_base"), 0xFFFFFF), new MaterialLayer(SilentGear.getId("tip"), color), new MaterialLayer(SilentGear.getId("tip_shine"), 0xFFFFFF));
        return this;
    }

    public MaterialBuilder displayFragment(PartTextures texture, int color) {
        this.display(PartType.MAIN, GearType.FRAGMENT, new MaterialLayer(texture, color));
        return this;
    }

    public MaterialBuilder display(PartType partType, PartTextureSet texture, int color) {
        this.display(partType, GearType.ALL, texture, color);
        if (partType != PartType.MAIN) {
            this.display(partType, GearType.PART, new MaterialLayer(partType.getName(), color));
        }
        return this;
    }

    public MaterialBuilder display(PartType partType, GearType gearType, PartTextureSet texture, int color) {
        MaterialLayerList materialLayerList = new MaterialLayerList(partType, texture, color);
        return this.display(partType, gearType, materialLayerList);
    }

    public MaterialBuilder display(PartType partType, MaterialLayer ... layers) {
        return this.display(partType, GearType.ALL, layers);
    }

    public MaterialBuilder display(PartType partType, GearType gearType, MaterialLayer ... layers) {
        return this.display(partType, gearType, new MaterialLayerList(layers));
    }

    public MaterialBuilder display(PartType partType, GearType gearType, MaterialLayerList layers) {
        this.display.put(PartGearKey.of(gearType, partType), layers);
        if (partType == PartType.MAIN && !this.display.containsKey(PartGearKey.of(GearType.FRAGMENT, partType))) {
            int color = layers.getLayers().isEmpty() ? 0xFFFFFF : layers.getLayers().get(0).getColor();
            this.displayFragment(PartTextures.METAL, color);
        }
        return this;
    }

    public MaterialBuilder noModels() {
        this.hasModels = false;
        return this;
    }

    public MaterialBuilder noStats(PartType partType) {
        this.stats.computeIfAbsent(partType, pt -> new StatModifierMap());
        return this;
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, float value) {
        return this.stat(partType, stat, GearType.ALL, value, StatInstance.Operation.AVG);
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, GearType gearType, float value) {
        return this.stat(partType, stat, gearType, value, StatInstance.Operation.AVG);
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, float value, StatInstance.Operation operation) {
        return this.stat(partType, stat, GearType.ALL, value, operation);
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, GearType gearType, float value, StatInstance.Operation operation) {
        StatGearKey key = StatGearKey.of(stat, gearType);
        StatInstance mod = StatInstance.of(value, operation, key);
        StatModifierMap map = this.stats.computeIfAbsent(partType, pt -> new StatModifierMap());
        map.put(stat, gearType, mod);
        return this;
    }

    public MaterialBuilder stat(PartType partType, ResourceLocation statId, float value) {
        return this.stat(partType, statId, value, StatInstance.Operation.AVG);
    }

    public MaterialBuilder stat(PartType partType, ResourceLocation statId, float value, StatInstance.Operation operation) {
        return this.stat(partType, (IItemStat)LazyItemStat.of(statId), value, operation);
    }

    @Deprecated
    public MaterialBuilder mainStatsCommon(float toolDurability, float armorDurability, float enchantability, float rarity) {
        this.stat(PartType.MAIN, ItemStats.DURABILITY, toolDurability);
        this.stat(PartType.MAIN, ItemStats.ARMOR_DURABILITY, armorDurability);
        this.stat(PartType.MAIN, ItemStats.ENCHANTABILITY, enchantability);
        this.stat(PartType.MAIN, ItemStats.RARITY, rarity);
        return this;
    }

    public MaterialBuilder mainStatsCommon(float toolDurability, float armorDurability, float enchantability, float rarity, float chargeability) {
        this.stat(PartType.MAIN, ItemStats.DURABILITY, toolDurability);
        this.stat(PartType.MAIN, ItemStats.ARMOR_DURABILITY, armorDurability);
        this.stat(PartType.MAIN, ItemStats.ENCHANTABILITY, enchantability);
        this.stat(PartType.MAIN, ItemStats.RARITY, rarity);
        this.stat(PartType.MAIN, ItemStats.CHARGEABILITY, chargeability);
        return this;
    }

    public MaterialBuilder mainStatsHarvest(int harvestLevel, float harvestSpeed) {
        this.stat(PartType.MAIN, ItemStats.HARVEST_LEVEL, (float)harvestLevel);
        this.stat(PartType.MAIN, ItemStats.HARVEST_SPEED, harvestSpeed);
        return this;
    }

    public MaterialBuilder mainStatsMelee(float attackDamage, float magicDamage, float attackSpeed) {
        this.stat(PartType.MAIN, ItemStats.MELEE_DAMAGE, attackDamage);
        if (magicDamage > 0.0f) {
            this.stat(PartType.MAIN, ItemStats.MAGIC_DAMAGE, magicDamage);
        }
        this.stat(PartType.MAIN, ItemStats.ATTACK_SPEED, attackSpeed);
        return this;
    }

    public MaterialBuilder mainStatsRanged(float rangedDamage, float rangedSpeed) {
        this.stat(PartType.MAIN, ItemStats.RANGED_DAMAGE, rangedDamage);
        this.stat(PartType.MAIN, ItemStats.RANGED_SPEED, rangedSpeed);
        return this;
    }

    public MaterialBuilder mainStatsProjectile(float projectileSpeed, float projectileAccuracy) {
        this.stat(PartType.MAIN, ItemStats.PROJECTILE_SPEED, projectileSpeed);
        this.stat(PartType.MAIN, ItemStats.PROJECTILE_ACCURACY, projectileAccuracy);
        return this;
    }

    @Deprecated
    public MaterialBuilder mainStatsArmor(float armor, float toughness, float magicArmor) {
        this.stat(PartType.MAIN, ItemStats.ARMOR, armor);
        this.stat(PartType.MAIN, ItemStats.ARMOR_TOUGHNESS, toughness);
        this.stat(PartType.MAIN, ItemStats.MAGIC_ARMOR, magicArmor);
        return this;
    }

    public MaterialBuilder mainStatsArmor(float head, float chest, float legs, float feet, float toughness, float magicArmor) {
        if (this.stats.get(PartType.MAIN).containsKey(StatGearKey.of(ItemStats.ARMOR, GearType.ALL))) {
            throw new IllegalStateException("Called mainStatsArmor when armor stat is already defined");
        }
        if (head > 0.0f && chest > 0.0f && legs > 0.0f && feet > 0.0f) {
            float sum = head + chest + legs + feet;
            this.stat(PartType.MAIN, ItemStats.ARMOR, sum);
        }
        if (head > 0.0f) {
            this.stat(PartType.MAIN, (IItemStat)ItemStats.ARMOR, GearType.HELMET, head);
        }
        if (chest > 0.0f) {
            this.stat(PartType.MAIN, (IItemStat)ItemStats.ARMOR, GearType.CHESTPLATE, chest);
        }
        if (legs > 0.0f) {
            this.stat(PartType.MAIN, (IItemStat)ItemStats.ARMOR, GearType.LEGGINGS, legs);
        }
        if (feet > 0.0f) {
            this.stat(PartType.MAIN, (IItemStat)ItemStats.ARMOR, GearType.BOOTS, feet);
        }
        if (toughness > 0.0f) {
            this.stat(PartType.MAIN, ItemStats.ARMOR_TOUGHNESS, toughness);
        }
        if (magicArmor > 0.0f) {
            this.stat(PartType.MAIN, ItemStats.MAGIC_ARMOR, magicArmor);
        }
        return this;
    }

    public MaterialBuilder trait(PartType partType, DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        ITraitInstance inst = TraitInstance.of(trait, level, conditions);
        List list = this.traits.computeIfAbsent(partType, pt -> new ArrayList());
        list.add(inst);
        return this;
    }

    @Deprecated
    public MaterialBuilder trait(PartType partType, ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        LazyTraitInstance inst = TraitInstance.lazy(traitId, level, conditions);
        List list = this.traits.computeIfAbsent(partType, pt -> new ArrayList());
        list.add(inst);
        return this;
    }

    private void validate() {
        if (this.hasModels) {
            for (PartType type : this.stats.keySet()) {
                if (!this.display.keySet().stream().noneMatch(key -> key.getPartType().equals(type))) continue;
                throw new NullPointerException(String.format("Material builder %s has no model data for part type %s", this.id, type.getName()));
            }
        }
    }

    public JsonObject serializeModel() {
        MaterialDisplay model = MaterialDisplay.of(this.id, this.display);
        return model.serialize();
    }

    public JsonObject serialize() {
        this.validate();
        JsonObject json = new JsonObject();
        json.addProperty("type", this.serializer.getName().toString());
        json.addProperty("simple", Boolean.valueOf(this.simple));
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        if (!this.loadConditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (ICondition iCondition : this.loadConditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)iCondition));
            }
            json.add("conditions", (JsonElement)array);
        }
        JsonObject availability = new JsonObject();
        if (this.tier >= 0) {
            JsonArray array;
            availability.addProperty("tier", (Number)this.tier);
            if (!this.categories.isEmpty()) {
                array = new JsonArray();
                for (IMaterialCategory category : this.categories) {
                    array.add(category.getName());
                }
                availability.add("categories", (JsonElement)array);
            }
            availability.addProperty("visible", Boolean.valueOf(this.visible));
            array = new JsonArray();
            for (String gearType : this.gearBlacklist) {
                array.add(gearType);
            }
            availability.add("gear_blacklist", (JsonElement)array);
            availability.addProperty("can_salvage", Boolean.valueOf(this.canSalvage));
        }
        if (!availability.entrySet().isEmpty()) {
            json.add("availability", (JsonElement)availability);
        }
        JsonObject craftingItems = new JsonObject();
        if (this.ingredient != Ingredient.f_43901_) {
            craftingItems.add("main", this.ingredient.m_43942_());
        }
        if (!this.partSubstitutes.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            this.partSubstitutes.forEach((type, ing) -> subs.add(SilentGear.shortenId(type.getName()), ing.m_43942_()));
            craftingItems.add("subs", (JsonElement)jsonObject);
        }
        json.add("crafting_items", (JsonElement)craftingItems);
        if (this.name != null) {
            json.add("name", Component.Serializer.m_130716_((Component)this.name));
        }
        if (this.namePrefix != null) {
            json.add("name_prefix", Component.Serializer.m_130716_((Component)this.namePrefix));
        }
        if (!this.stats.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            this.stats.forEach((partType, map) -> statsJson.add(SilentGear.shortenId(partType.getName()), (JsonElement)map.serialize()));
            json.add("stats", (JsonElement)jsonObject);
        }
        if (!this.traits.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            this.traits.forEach((partType, list) -> {
                JsonArray array = new JsonArray();
                list.forEach(t -> array.add((JsonElement)t.serialize()));
                traitsJson.add(SilentGear.shortenId(partType.getName()), (JsonElement)array);
            });
            json.add("traits", (JsonElement)jsonObject);
        }
        json.add("model", (JsonElement)this.serializeModel());
        return json;
    }
}

