/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundingRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Item resultItem;
    private final int resultCount;
    private DataResource<IMaterial> resultMaterial;

    public CompoundingRecipeBuilder(RecipeSerializer<?> serializer, Item resultItem, int count) {
        this.serializer = serializer;
        this.resultItem = resultItem;
        this.resultCount = count;
    }

    public static CompoundingRecipeBuilder metalBuilder(ItemLike result, int count) {
        return new CompoundingRecipeBuilder((RecipeSerializer)ModRecipes.COMPOUNDING_METAL.get(), result.m_5456_(), count);
    }

    public static CompoundingRecipeBuilder gemBuilder(ItemLike result, int count) {
        return new CompoundingRecipeBuilder((RecipeSerializer)ModRecipes.COMPOUNDING_GEM.get(), result.m_5456_(), count);
    }

    public CompoundingRecipeBuilder withCustomMaterial(DataResource<IMaterial> material) {
        this.resultMaterial = material;
        return this;
    }

    public CompoundingRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CompoundingRecipeBuilder addIngredient(ItemLike item, int count) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
    }

    public CompoundingRecipeBuilder addIngredient(Tag<Item> tag) {
        return this.addIngredient(Ingredient.m_43911_(tag));
    }

    public CompoundingRecipeBuilder addIngredient(Tag<Item> tag, int count) {
        return this.addIngredient(Ingredient.m_43911_(tag), count);
    }

    public CompoundingRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public CompoundingRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Object name = NameUtils.from((IForgeRegistryEntry)this.resultItem).m_135815_();
        if (this.resultMaterial != null) {
            name = (String)name + "." + this.resultMaterial.getId().m_135815_();
        }
        this.build(consumer, new ResourceLocation(this.serializer.getRegistryName() + "/" + (String)name));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;

        public Result(ResourceLocation recipeId) {
            this.recipeId = recipeId;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredients", (JsonElement)this.serializeIngredients());
            json.add("result", (JsonElement)this.serializeResult());
        }

        private JsonArray serializeIngredients() {
            JsonArray ret = new JsonArray();
            for (Ingredient ingredient : CompoundingRecipeBuilder.this.ingredients) {
                ret.add(ingredient.m_43942_());
            }
            return ret;
        }

        private JsonObject serializeResult() {
            JsonObject ret = new JsonObject();
            ret.addProperty("item", NameUtils.from((IForgeRegistryEntry)CompoundingRecipeBuilder.this.resultItem).toString());
            if (CompoundingRecipeBuilder.this.resultCount > 1) {
                ret.addProperty("count", (Number)CompoundingRecipeBuilder.this.resultCount);
            }
            if (CompoundingRecipeBuilder.this.resultMaterial != null) {
                ret.addProperty("material", CompoundingRecipeBuilder.this.resultMaterial.getId().toString());
            }
            return ret;
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        public RecipeSerializer<?> m_6637_() {
            return CompoundingRecipeBuilder.this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

