/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.gear.trait.condition.GearTypeTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.OrTraitCondition;
import net.silentchaos512.gear.util.DataResource;

public class TraitBuilder {
    protected final ResourceLocation traitId;
    protected final int maxLevel;
    protected final ResourceLocation type;
    private Component name;
    private Component description;
    private final Collection<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
    private final Collection<ResourceLocation> cancelsList = new ArrayList<ResourceLocation>();
    private final Collection<ResourceLocation> overridesList = new ArrayList<ResourceLocation>();
    private final Collection<Component> extraWikiLines = new ArrayList<Component>();
    private Consumer<JsonObject> extraData = json -> {};

    public TraitBuilder(DataResource<ITrait> trait, int maxLevel, ITraitSerializer<?> serializer) {
        this(trait.getId(), maxLevel, serializer);
    }

    public TraitBuilder(ResourceLocation traitId, int maxLevel, ITraitSerializer<?> serializer) {
        this.traitId = traitId;
        this.type = serializer.getName();
        this.maxLevel = maxLevel;
        this.name = new TranslatableComponent(Util.m_137492_((String)"trait", (ResourceLocation)traitId));
        this.description = new TranslatableComponent(Util.m_137492_((String)"trait", (ResourceLocation)traitId) + ".desc");
    }

    public static TraitBuilder simple(DataResource<ITrait> trait, int maxLevel) {
        return TraitBuilder.simple(trait.getId(), maxLevel);
    }

    public static TraitBuilder simple(ResourceLocation traitId, int maxLevel) {
        return new TraitBuilder(traitId, maxLevel, SimpleTrait.SERIALIZER);
    }

    public TraitBuilder setName(Component text) {
        this.name = text;
        return this;
    }

    public TraitBuilder setDescription(Component text) {
        this.description = text;
        return this;
    }

    public TraitBuilder withConditions(ITraitCondition ... conditions) {
        Collections.addAll(this.conditions, conditions);
        return this;
    }

    public TraitBuilder withGearTypeCondition(GearType first, GearType ... rest) {
        if (rest.length > 0) {
            ArrayList<GearType> types = new ArrayList<GearType>(rest.length + 1);
            types.add(first);
            Collections.addAll(types, rest);
            ITraitCondition[] values = (GearTypeTraitCondition[])types.stream().map(GearTypeTraitCondition::new).toArray(GearTypeTraitCondition[]::new);
            return this.withConditions(new OrTraitCondition(values));
        }
        return this.withConditions(new GearTypeTraitCondition(first));
    }

    public TraitBuilder cancelsWith(DataResource<ITrait> trait) {
        return this.cancelsWith(trait.getId());
    }

    public TraitBuilder cancelsWith(ResourceLocation trait) {
        this.cancelsList.add(trait);
        return this;
    }

    public TraitBuilder overridesTrait(DataResource<ITrait> trait) {
        return this.overridesTrait(trait.getId());
    }

    public TraitBuilder overridesTrait(ResourceLocation trait) {
        this.overridesList.add(trait);
        return this;
    }

    public TraitBuilder extraWikiLines(String ... lines) {
        for (String line : lines) {
            this.extraWikiLines.add((Component)new TextComponent(line));
        }
        return this;
    }

    public TraitBuilder extraWikiLines(Component ... lines) {
        this.extraWikiLines.addAll(Arrays.asList(lines));
        return this;
    }

    public TraitBuilder extraData(Consumer<JsonObject> consumer) {
        this.extraData = consumer;
        return this;
    }

    public JsonObject serialize() {
        JsonArray array;
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("max_level", (Number)this.maxLevel);
        if (!this.conditions.isEmpty()) {
            array = new JsonArray();
            this.conditions.forEach(c -> array.add((JsonElement)TraitSerializers.serializeCondition(c)));
            json.add("conditions", (JsonElement)array);
        }
        json.add("name", Component.Serializer.m_130716_((Component)this.name));
        json.add("description", Component.Serializer.m_130716_((Component)this.description));
        if (!this.cancelsList.isEmpty()) {
            JsonArray cancelsArray = new JsonArray();
            this.cancelsList.forEach(id -> cancelsArray.add(id.toString()));
            json.add("cancels_with", (JsonElement)cancelsArray);
        }
        if (!this.overridesList.isEmpty()) {
            JsonArray overridesArray = new JsonArray();
            this.overridesList.forEach(id -> overridesArray.add(id.toString()));
            json.add("overrides", (JsonElement)overridesArray);
        }
        if (!this.extraWikiLines.isEmpty()) {
            array = new JsonArray();
            this.extraWikiLines.forEach(t -> array.add(Component.Serializer.m_130716_((Component)t)));
            json.add("extra_wiki_lines", (JsonElement)array);
        }
        this.extraData.accept(json);
        return json;
    }
}

