/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.enchantment;

import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.silentchaos512.gear.api.enchantment.IStatModifierEnchantment;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class StatModifierEnchantment
extends Enchantment
implements IStatModifierEnchantment {
    public StatModifierEnchantment(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot[] slots) {
        super(rarityIn, typeIn, slots);
    }

    @Override
    @Nullable
    public StatInstance modifyStat(StatGearKey stat, StatInstance mod, ChargedProperties charge) {
        if (this.isSupportedModifierOp(mod)) {
            SplitItemStat splitItemStat;
            float modifiedStatValue = (float)this.getModifiedStatValue(stat, mod, charge);
            if (stat.getStat() instanceof SplitItemStat && !(splitItemStat = (SplitItemStat)stat.getStat()).getSplitTypes().contains(stat.getGearType())) {
                modifiedStatValue = mod.getValue() + (modifiedStatValue - mod.getValue()) * (float)splitItemStat.getSplitTypes().size();
            }
            return mod.copySetValue(modifiedStatValue);
        }
        return null;
    }

    protected double getModifiedStatValue(StatGearKey stat, StatInstance mod, ChargedProperties charge) {
        if (stat.getStat() == ItemStats.DURABILITY) {
            return (double)mod.getValue() * Math.pow(1.25, charge.getChargeValue());
        }
        if (stat.getStat() == ItemStats.ARMOR_DURABILITY) {
            return (double)mod.getValue() * Math.pow(1.1, charge.getChargeValue());
        }
        if (stat.getStat() == ItemStats.ENCHANTABILITY) {
            return (double)mod.getValue() * (1.0 + (double)charge.getChargeLevel() * Math.sqrt(charge.getChargeability() - 1.0f));
        }
        if (stat.getStat() == ItemStats.HARVEST_LEVEL) {
            return mod.getValue() + 1.0f;
        }
        if (stat.getStat() == ItemStats.HARVEST_SPEED) {
            return (double)mod.getValue() + 1.5 * (double)charge.getChargeLevel() * (double)charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.MELEE_DAMAGE) {
            return mod.getValue() + charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.MAGIC_DAMAGE) {
            return mod.getValue() + charge.getChargeValue();
        }
        if (stat.getStat() == ItemStats.RANGED_DAMAGE) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.ARMOR) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.ARMOR_TOUGHNESS) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        if (stat.getStat() == ItemStats.MAGIC_ARMOR) {
            return (double)mod.getValue() + (double)charge.getChargeValue() / 2.0;
        }
        return mod.getValue();
    }

    protected boolean isSupportedModifierOp(StatInstance mod) {
        return mod.getOp() == StatInstance.Operation.AVG || mod.getOp() == StatInstance.Operation.MAX || mod.getOp() == StatInstance.Operation.ADD;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6081_(ItemStack stack) {
        return MaterialManager.from(stack) != null;
    }

    protected boolean m_5975_(Enchantment ench) {
        return !(ench instanceof IStatModifierEnchantment);
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }
}

