/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import net.silentchaos512.gear.util.TextUtil;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MaterialManager
implements ResourceManagerReloadListener {
    public static final MaterialManager INSTANCE = new MaterialManager();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Marker MARKER = MarkerManager.getMarker((String)"MaterialManager");
    private static final String DATA_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IMaterial> MATERIALS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();
    private static final Collection<String> INGREDIENT_CONFLICT_LIST = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        Collection resources = resourceManager.m_6540_(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        HashMultimap ingredientConflicts = HashMultimap.create();
        ArrayList<ResourceLocation> skippedList = new ArrayList<ResourceLocation>();
        Map<ResourceLocation, IMaterial> map = MATERIALS;
        synchronized (map) {
            MATERIALS.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading material files");
            for (ResourceLocation id : resources) {
                String path = id.m_135815_().substring(DATA_PATH.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                String packName = "ERROR";
                try {
                    Resource iresource = resourceManager.m_142591_(id);
                    try {
                        packName = iresource.m_7816_();
                        JsonObject json = (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load material {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            skippedList.add(name);
                            continue;
                        }
                        IMaterial material = MaterialSerializers.deserialize(name, packName, json);
                        MATERIALS.put(material.getId(), material);
                        MaterialManager.addIngredientChecks((Multimap<String, IMaterial>)ingredientConflicts, material, json);
                    }
                    finally {
                        if (iresource == null) continue;
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
            }
        }
        MaterialManager.checkForIngredientConflicts((Multimap<String, IMaterial>)ingredientConflicts);
        MaterialManager.logSkippedMaterials(skippedList);
    }

    private static void addIngredientChecks(Multimap<String, IMaterial> map, IMaterial material, JsonObject json) {
        JsonObject craftingItemsJson = json.getAsJsonObject("crafting_items");
        if (craftingItemsJson != null && craftingItemsJson.has("main")) {
            JsonElement mainJson = craftingItemsJson.get("main");
            String key = GSON.toJson(mainJson);
            map.put((Object)key, (Object)material);
        }
    }

    private static void checkForIngredientConflicts(Multimap<String, IMaterial> map) {
        INGREDIENT_CONFLICT_LIST.clear();
        for (String key : map.keySet()) {
            if (map.get((Object)key).size() <= 1) continue;
            String collect = map.get((Object)key).stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(" and "));
            INGREDIENT_CONFLICT_LIST.add("Conflicting crafting items for: " + collect);
        }
    }

    private static void logSkippedMaterials(Collection<ResourceLocation> list) {
        if (!list.isEmpty()) {
            SilentGear.LOGGER.info("Skipped loading {} material(s), as their conditions were not met. This is usually NOT an error!", (Object)list.size());
            SilentGear.LOGGER.info("Skipped materials: {}", (Object)list.stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
    }

    public static List<IMaterial> getValues() {
        return MaterialManager.getValues(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getValues(boolean includeChildren) {
        Map<ResourceLocation, IMaterial> map = MATERIALS;
        synchronized (map) {
            ArrayList<IMaterial> list = new ArrayList<IMaterial>();
            for (IMaterial m : MATERIALS.values()) {
                if (!includeChildren && m.getParent() != null) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getChildren(IMaterial material) {
        Map<ResourceLocation, IMaterial> map = MATERIALS;
        synchronized (map) {
            ArrayList<IMaterial> list = new ArrayList<IMaterial>();
            for (IMaterial m : MATERIALS.values()) {
                if (m.getParent() != material) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMaterial get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Map<ResourceLocation, IMaterial> map = MATERIALS;
        synchronized (map) {
            return MATERIALS.get(id);
        }
    }

    @Nullable
    public static IMaterial from(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.getIngredient().test(stack)) continue;
            return material;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSyncPacket(SyncMaterialsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Map<ResourceLocation, IMaterial> map = MATERIALS;
        synchronized (map) {
            ImmutableMap oldMaterials = ImmutableMap.copyOf(MATERIALS);
            MATERIALS.clear();
            for (IMaterial mat : msg.getMaterials()) {
                mat.retainData((IMaterial)oldMaterials.get(mat.getId()));
                MATERIALS.put(mat.getId(), mat);
            }
            SilentGear.LOGGER.info("Read {} materials from server", (Object)MATERIALS.size());
        }
        ctx.get().setPacketHandled(true);
    }

    public static Collection<Component> getErrorMessages(ServerPlayer player) {
        ArrayList<Component> ret = new ArrayList<Component>();
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            ret.add((Component)TextUtil.withColor((MutableComponent)new TextComponent("[Silent Gear] The following materials failed to load, check your log file:"), ChatFormatting.RED));
            ret.add((Component)new TextComponent(listStr));
        }
        INGREDIENT_CONFLICT_LIST.forEach(line -> {
            MutableComponent text = TextUtil.withColor((MutableComponent)new TextComponent(line), ChatFormatting.YELLOW);
            ret.add((Component)new TextComponent("[Silent Gear] ").m_7220_((Component)text));
        });
        return ret;
    }
}

