/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.gear.material.modifier.GradeMaterialModifier;
import net.silentchaos512.gear.gear.material.modifier.StarchargedMaterialModifier;

public class MaterialModifiers {
    private static final Map<ResourceLocation, IMaterialModifierType> MODIFIERS = new LinkedHashMap<ResourceLocation, IMaterialModifierType>();
    public static final GradeMaterialModifier.Type GRADE = new GradeMaterialModifier.Type();
    public static final ChargedMaterialModifier.Type<StarchargedMaterialModifier> STARCHARGED = new ChargedMaterialModifier.Type<StarchargedMaterialModifier>(StarchargedMaterialModifier::new, "SG_Starcharged");

    public static void registerType(ResourceLocation id, IMaterialModifierType type) {
        if (MODIFIERS.containsKey(id)) {
            throw new IllegalArgumentException("Already have material modifier with ID " + id);
        }
        MODIFIERS.put(id, type);
        SilentGear.LOGGER.info("Registered material modifier {}", (Object)id);
    }

    public static Collection<IMaterialModifier> readFromMaterial(IMaterialInstance material) {
        ArrayList<IMaterialModifier> ret = new ArrayList<IMaterialModifier>();
        for (IMaterialModifierType type : MODIFIERS.values()) {
            IMaterialModifier modifier = type.read(material);
            if (modifier == null) continue;
            ret.add(modifier);
        }
        return ret;
    }

    public static Collection<IMaterialModifierType> getTypes() {
        return MODIFIERS.values();
    }

    static {
        MaterialModifiers.registerType(SilentGear.getId("grade"), GRADE);
        MaterialModifiers.registerType(SilentGear.getId("starcharged"), STARCHARGED);
    }
}

