/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class GradeMaterialModifier
implements IMaterialModifier {
    private final MaterialGrade grade;

    public GradeMaterialModifier(MaterialGrade grade) {
        this.grade = grade;
    }

    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public List<StatInstance> modifyStats(PartType partType, StatGearKey key, List<StatInstance> statMods) {
        if (key.getStat().isAffectedByGrades() && this.grade != null) {
            float bonus = (float)this.grade.bonusPercent / 100.0f;
            ArrayList<StatInstance> ret = new ArrayList<StatInstance>();
            for (StatInstance mod : statMods) {
                float value = mod.getValue();
                ret.add(mod.copySetValue(value + Math.abs(value) * bonus));
            }
            return ret;
        }
        return statMods;
    }

    @Override
    public void appendTooltip(List<Component> tooltip) {
        MutableComponent text = TextUtil.withColor(this.grade.getDisplayName(), Color.DEEPSKYBLUE);
        tooltip.add((Component)new TranslatableComponent("part.silentgear.gradeOnPart", new Object[]{text}));
    }

    @Override
    public MutableComponent modifyMaterialName(MutableComponent name) {
        if (this.grade != MaterialGrade.NONE) {
            return name.m_7220_((Component)TextUtil.translate("misc", "spaceBrackets", this.grade.getDisplayName()));
        }
        return name;
    }

    public static class Type
    implements IMaterialModifierType<GradeMaterialModifier> {
        @Override
        public void removeModifier(ItemStack stack) {
            MaterialGrade.NONE.setGradeOnStack(stack);
        }

        @Override
        @Nullable
        public GradeMaterialModifier read(IMaterialInstance material) {
            MaterialGrade grade = MaterialGrade.fromStack(material.getItem());
            return new GradeMaterialModifier(grade);
        }

        @Override
        public void write(GradeMaterialModifier modifier, ItemStack stack) {
            modifier.grade.setGradeOnStack(stack);
        }
    }
}

