/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;

public abstract class AbstractGearPart
implements IGearPart {
    private final ResourceLocation name;
    String packName = "UNKNOWN PACK";
    Ingredient ingredient = Ingredient.f_43901_;
    boolean visible = true;
    int tier = -1;
    List<String> blacklistedGearTypes = new ArrayList<String>();
    protected StatModifierMap stats = new StatModifierMap();
    List<TraitInstance> traits = new ArrayList<TraitInstance>();
    Component displayName;
    @Nullable
    Component namePrefix = null;

    public AbstractGearPart(ResourceLocation location) {
        this.name = location;
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public int getTier(PartData part) {
        return this.tier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    public void updateCraftingItems(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(IPartData part, PartType partType, StatGearKey key, ItemStack gear) {
        ArrayList<StatInstance> mods = new ArrayList<StatInstance>(this.stats.get(key));
        GetStatModifierEvent event = new GetStatModifierEvent((PartData)part, (ItemStat)key.getStat(), mods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Override
    public Collection<TraitInstance> getTraits(IPartData part, PartGearKey partKey, ItemStack gear) {
        return Collections.unmodifiableList(this.traits);
    }

    @Override
    public boolean isCraftingAllowed(IPartData part, PartType partType, GearType gearType, @Nullable Container inventory) {
        if (!gearType.matches(GearType.ALL)) {
            return true;
        }
        for (String blacklistedGearType : this.blacklistedGearTypes) {
            if (!gearType.matches(blacklistedGearType)) continue;
            return false;
        }
        return IGearPart.super.isCraftingAllowed(part, partType, gearType, inventory);
    }

    @Override
    public Component getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (this.displayName == null) {
            return new TextComponent("<error: missing name>");
        }
        return this.displayName.m_6881_();
    }

    @Override
    public Component getDisplayName(@Nullable IPartData part, PartType type, ItemStack gear) {
        if (this.displayName == null) {
            return new TextComponent("<error: missing name>");
        }
        return this.displayName.m_6881_();
    }

    @Override
    public Component getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        return this.namePrefix != null ? this.namePrefix.m_6881_() : null;
    }

    @Override
    public void addInformation(PartData part, ItemStack gear, List<Component> tooltip, TooltipFlag flag) {
    }

    public List<GearType> getBlacklistedGearTypes() {
        return this.blacklistedGearTypes.stream().map(GearType::get).filter(GearType::isGear).collect(Collectors.toList());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return "AbstractGearPart{id=" + this.name + ", partType=" + this.getType() + "}";
    }

    public static class Serializer<T extends AbstractGearPart>
    implements IPartSerializer<T> {
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> function;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> function) {
            this.serializerId = serializerId;
            this.function = function;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            return this.read(id, json, true);
        }

        protected T read(ResourceLocation id, JsonObject json, boolean failOnMissingElement) {
            JsonElement elementAvailability;
            JsonElement craftingItem;
            JsonElement elementTraits;
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            JsonElement elementStats = json.get("stats");
            if (elementStats != null) {
                StatModifierMap statMap = StatModifierMap.deserialize(elementStats);
                statMap.keySet().forEach(key -> part.stats.removeAll(key));
                statMap.forEach((key, mod) -> part.stats.put((StatGearKey)key, (StatInstance)mod));
            }
            if ((elementTraits = json.get("traits")) != null && elementTraits.isJsonArray()) {
                JsonArray array = elementTraits.getAsJsonArray();
                ArrayList<TraitInstance> traitsList = new ArrayList<TraitInstance>();
                for (JsonElement element : array) {
                    traitsList.add(TraitInstance.deserialize(element.getAsJsonObject()));
                }
                if (!traitsList.isEmpty()) {
                    part.traits.clear();
                    part.traits.addAll(traitsList);
                }
            }
            if ((craftingItem = json.get("crafting_item")) != null) {
                part.ingredient = Ingredient.m_43917_((JsonElement)craftingItem);
            } else if (failOnMissingElement) {
                throw new JsonSyntaxException("Missing 'crafting_item'");
            }
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            part.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                part.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
            if ((elementAvailability = json.get("availability")) != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                part.tier = GsonHelper.m_13824_((JsonObject)obj, (String)"tier", (int)part.tier);
                part.visible = GsonHelper.m_13855_((JsonObject)obj, (String)"visible", (boolean)part.visible);
                JsonArray blacklist = Serializer.getGearBlacklist(obj);
                if (blacklist != null) {
                    part.blacklistedGearTypes.clear();
                    blacklist.forEach(e -> part.blacklistedGearTypes.add(e.getAsString()));
                }
            }
            return (T)part;
        }

        private static Component deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = GsonHelper.m_13855_((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslatableComponent(name) : new TextComponent(name);
            }
            return (Component)Objects.requireNonNull(Component.Serializer.m_130691_((JsonElement)json));
        }

        @Nullable
        private static JsonArray getGearBlacklist(JsonObject json) {
            if (json.has("gear_blacklist")) {
                return GsonHelper.m_13933_((JsonObject)json, (String)"gear_blacklist");
            }
            if (json.has("tool_blacklist")) {
                return GsonHelper.m_13933_((JsonObject)json, (String)"tool_blacklist");
            }
            return null;
        }

        @Override
        public T read(ResourceLocation id, FriendlyByteBuf buffer) {
            AbstractGearPart part = (AbstractGearPart)this.function.apply(id);
            part.packName = buffer.m_130277_();
            part.displayName = buffer.m_130238_();
            if (buffer.readBoolean()) {
                part.namePrefix = buffer.m_130238_();
            }
            part.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            part.tier = buffer.readByte();
            part.visible = buffer.readBoolean();
            part.blacklistedGearTypes.clear();
            int blacklistSize = buffer.readByte();
            for (int i = 0; i < blacklistSize; ++i) {
                part.blacklistedGearTypes.add(buffer.m_130277_());
            }
            part.stats = StatModifierMap.read(buffer);
            this.readTraits(buffer, part);
            return (T)part;
        }

        @Override
        public void write(FriendlyByteBuf buffer, T part) {
            buffer.m_130070_(((AbstractGearPart)part).packName);
            buffer.m_130083_(((AbstractGearPart)part).getDisplayName(null, ItemStack.f_41583_));
            buffer.writeBoolean(((AbstractGearPart)part).namePrefix != null);
            if (((AbstractGearPart)part).namePrefix != null) {
                buffer.m_130083_(((AbstractGearPart)part).namePrefix);
            }
            ((AbstractGearPart)part).ingredient.m_43923_(buffer);
            buffer.writeByte(part.getTier());
            buffer.writeBoolean(((AbstractGearPart)part).visible);
            buffer.writeByte(((AbstractGearPart)part).blacklistedGearTypes.size());
            ((AbstractGearPart)part).blacklistedGearTypes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
            ((AbstractGearPart)part).stats.write(buffer);
            this.writeTraits(buffer, part);
        }

        private void readTraits(FriendlyByteBuf buffer, T part) {
            ((AbstractGearPart)part).traits.clear();
            int traitCount = buffer.m_130242_();
            for (int i = 0; i < traitCount; ++i) {
                ((AbstractGearPart)part).traits.add(TraitInstance.read(buffer));
            }
        }

        private void writeTraits(FriendlyByteBuf buffer, T part) {
            buffer.m_130130_(((AbstractGearPart)part).traits.size());
            ((AbstractGearPart)part).traits.forEach(inst -> inst.write(buffer));
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }
    }
}

