/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.InventoryUtils;

public final class PartData
implements IPartData {
    private static final Map<ResourceLocation, PartData> CACHE_UNGRADED_PARTS = new HashMap<ResourceLocation, PartData>();
    public static final String NBT_ID = "ID";
    private final IGearPart part;
    private final ItemStack craftingItem;

    private PartData(IGearPart part) {
        this(part, ItemStack.f_41583_);
    }

    private PartData(IGearPart part, ItemStack craftingItem) {
        this.part = part;
        this.craftingItem = craftingItem.m_41777_();
        if (!this.craftingItem.m_41619_()) {
            this.craftingItem.m_41764_(1);
        }
    }

    public static PartData of(IGearPart part) {
        ResourceLocation name = part.getId();
        if (CACHE_UNGRADED_PARTS.containsKey(name)) {
            return CACHE_UNGRADED_PARTS.get(name);
        }
        PartData inst = new PartData(part);
        CACHE_UNGRADED_PARTS.put(name, inst);
        return inst;
    }

    public static PartData of(IGearPart part, ItemStack craftingItem) {
        return new PartData(part, craftingItem);
    }

    public static IPartData of(DataResource<IGearPart> part, ItemStack craftingItem) {
        if (part.isPresent()) {
            return PartData.of(part.get(), craftingItem);
        }
        return LazyPartData.of(part, craftingItem);
    }

    @Nullable
    public static PartData from(ItemStack craftingItem) {
        return PartData.from(craftingItem, true);
    }

    @Nullable
    public static PartData from(ItemStack craftingItem, boolean checkSubstitutes) {
        IGearPart part = PartManager.from(craftingItem);
        if (part == null) {
            if (checkSubstitutes) {
                return PartData.fromMaterialSubstitute(craftingItem);
            }
            return null;
        }
        return PartData.of(part, craftingItem);
    }

    @Nullable
    private static PartData fromMaterialSubstitute(ItemStack stack) {
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.hasPartSubstitutes()) continue;
            for (PartType partType : PartType.getValues()) {
                Optional<? extends CompoundPartItem> item;
                Optional<Ingredient> ingredient = material.getPartSubstitute(partType);
                if (!ingredient.isPresent() || !ingredient.get().test(stack) || !(item = partType.getCompoundPartItem(GearType.PART)).isPresent()) continue;
                ItemStack result = item.get().create(MaterialInstance.of(material));
                return PartData.from(result, false);
            }
        }
        return null;
    }

    @Nullable
    public static PartData read(CompoundTag tags) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(tags.m_128461_(NBT_ID));
        if (id == null) {
            return null;
        }
        IGearPart part = PartManager.get(id);
        if (part == null) {
            return null;
        }
        ItemStack craftingItem = ItemStack.m_41712_((CompoundTag)tags.m_128469_("Item"));
        return PartData.of(part, craftingItem);
    }

    @Override
    public CompoundTag write(@Nonnull CompoundTag tags) {
        tags.m_128359_(NBT_ID, this.part.getId().toString());
        CompoundTag itemTag = new CompoundTag();
        this.craftingItem.m_41739_(itemTag);
        tags.m_128365_("Item", (Tag)itemTag);
        return tags;
    }

    @Override
    public ResourceLocation getId() {
        return this.part.getId();
    }

    @Override
    @Nonnull
    public IGearPart get() {
        return this.part;
    }

    @Override
    public ItemStack getItem() {
        return this.craftingItem;
    }

    @Override
    public int getTier() {
        return this.part.getTier(this);
    }

    @Override
    @Nonnull
    public PartType getType() {
        return this.part.getType();
    }

    @Override
    public GearType getGearType() {
        return this.part.getGearType();
    }

    @Override
    public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        return this.part.getStatModifiers(this, this.getType(), key, gear);
    }

    public boolean isCraftingAllowed(GearType gearType, @Nullable CraftingContainer inventory) {
        return this.part.isCraftingAllowed(this, this.getType(), gearType, (Container)inventory);
    }

    @Override
    public Component getDisplayName(PartType type, ItemStack gear) {
        return this.part.getDisplayName(this, type, gear);
    }

    public Component getDisplayName(ItemStack gear) {
        return this.part.getDisplayName(this, gear);
    }

    public Component getMaterialName(ItemStack gear) {
        return this.part.getMaterialName(this, gear);
    }

    @Override
    public String getModelKey() {
        return this.part.getModelKey(this);
    }

    public int getColor(ItemStack gear) {
        return this.getColor(gear, 0, 0);
    }

    public int getColor(ItemStack gear, int layer, int animationFrame) {
        return this.part.getColor(this, gear, layer, animationFrame);
    }

    @Override
    public void onAddToGear(ItemStack gear) {
        this.part.onAddToGear(gear, this);
    }

    public void onRemoveFromGear(ItemStack gear) {
        this.part.onRemoveFromGear(gear, this);
    }

    public String toString() {
        return "PartData{" + this.part + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartData partData = (PartData)o;
        return this.part.equals(partData.part) && InventoryUtils.canItemsStack((ItemStack)this.craftingItem, (ItemStack)partData.craftingItem);
    }

    public int hashCode() {
        return Objects.hash(this.part, this.craftingItem);
    }
}

