/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class PartManager
implements ResourceManagerReloadListener {
    public static final PartManager INSTANCE = new PartManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"PartManager");
    private static final String DATA_PATH = "silentgear_parts";
    private static final String DATA_PATH_OLD = "silentgear/parts";
    private static final Map<ResourceLocation, IGearPart> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static int highestMainPartTier = 0;
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    private PartManager() {
    }

    public static int getHighestMainPartTier() {
        return highestMainPartTier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection<ResourceLocation> resources = PartManager.getAllResources(resourceManager);
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading part files");
            for (ResourceLocation id : resources) {
                String path = id.m_135815_().substring(DATA_PATH.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                String packName = "ERROR";
                try {
                    Resource iresource = resourceManager.m_142591_(id);
                    try {
                        JsonObject json;
                        packName = iresource.m_7816_();
                        if (SilentGear.LOGGER.isTraceEnabled()) {
                            SilentGear.LOGGER.trace(MARKER, "Found likely part file: {}, trying to read as part {}", (Object)id, (Object)name);
                        }
                        if ((json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_6679_(), (Charset)StandardCharsets.UTF_8), JsonObject.class)) == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load part {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info("Skipping loading gear part {} as it's conditions were not met", (Object)name);
                            continue;
                        }
                        IGearPart part = PartSerializers.deserialize(name, json);
                        if (part instanceof AbstractGearPart) {
                            ((AbstractGearPart)part).packName = iresource.m_7816_();
                        }
                        PartManager.addPart(part);
                        highestMainPartTier = Math.max(highestMainPartTier, part.getTier());
                    }
                    finally {
                        if (iresource == null) continue;
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading gear part {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read gear part {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
            }
            SilentGear.LOGGER.info(MARKER, "Registered {} parts", (Object)MAP.size());
        }
    }

    private static Collection<ResourceLocation> getAllResources(ResourceManager resourceManager) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.addAll(resourceManager.m_6540_(DATA_PATH, s -> s.endsWith(".json")));
        list.addAll(resourceManager.m_6540_(DATA_PATH_OLD, s -> s.endsWith(".json")));
        return list;
    }

    private static void addPart(IGearPart part) {
        if (MAP.containsKey(part.getId())) {
            throw new IllegalStateException("Duplicate gear part " + part.getId());
        }
        MAP.put(part.getId(), part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IGearPart> getValues() {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    public static List<IGearPart> getPartsOfType(PartType type) {
        return PartManager.getValues().stream().filter(part -> part.getType() == type).collect(Collectors.toList());
    }

    @Deprecated
    public static Collection<IGearPart> getMains() {
        return PartManager.getPartsOfType(PartType.MAIN);
    }

    @Deprecated
    public static Collection<IGearPart> getRods() {
        return PartManager.getPartsOfType(PartType.ROD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IGearPart get(ResourceLocation id) {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IGearPart get(String id) {
        ResourceLocation partId = SilentGear.getIdWithDefaultNamespace(id);
        return partId != null ? PartManager.get(partId) : null;
    }

    @Nullable
    public static IGearPart from(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (IGearPart part : PartManager.getValues()) {
            if (!part.getIngredient().test(stack)) continue;
            return part;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handlePartSyncPacket(SyncGearPartsPacket packet, Supplier<NetworkEvent.Context> context) {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            ImmutableMap oldParts = ImmutableMap.copyOf(MAP);
            MAP.clear();
            for (IGearPart part : packet.getParts()) {
                part.retainData((IGearPart)oldParts.get(part.getId()));
                MAP.put(part.getId(), part);
            }
            SilentGear.LOGGER.info("Read {} parts from server", (Object)MAP.size());
        }
        context.get().setPacketHandled(true);
    }

    public static Collection<Component> getErrorMessages(ServerPlayer player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            return ImmutableList.of((Object)new TextComponent("[Silent Gear] The following gear parts failed to load, check your log file:").m_130940_(ChatFormatting.RED), (Object)new TextComponent(listStr));
        }
        return ImmutableList.of();
    }
}

