/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.commons.lang3.tuple.Triple;

public final class EnchantmentTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("enchantment");
    public static final ITraitSerializer<EnchantmentTrait> SERIALIZER = new SimpleTrait.Serializer<EnchantmentTrait>(SERIALIZER_ID, EnchantmentTrait::new, EnchantmentTrait::readJson, EnchantmentTrait::readBuffer, EnchantmentTrait::writeBuffer);
    private final Map<String, List<EnchantmentData>> enchantments = new HashMap<String, List<EnchantmentData>>();

    private EnchantmentTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onRecalculatePost(TraitActionContext context) {
        ItemStack gear = context.getGear();
        GearType gearType = GearHelper.getType(gear);
        int traitLevel = context.getTraitLevel();
        this.enchantments.forEach((type, list) -> {
            if (gearType.matches((String)type)) {
                this.addEnchantments(gear, traitLevel, (Iterable<EnchantmentData>)list);
            }
        });
    }

    public static void removeTraitEnchantments(ItemStack gear) {
        Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> enchants = EnchantmentTrait.getEnchantmentsOnGear(gear);
        ArrayList<Enchantment> toRemove = new ArrayList<Enchantment>();
        for (Enchantment enchantment : enchants.keySet()) {
            Triple<Integer, ResourceLocation, Integer> info = enchants.get(enchantment);
            if ((Integer)info.getRight() <= 0) continue;
            toRemove.add(enchantment);
        }
        for (Enchantment enchantment : toRemove) {
            enchants.remove(enchantment);
        }
        EnchantmentTrait.setEnchantmentsOnGear(gear, enchants);
    }

    private void addEnchantments(ItemStack gear, int traitLevel, Iterable<EnchantmentData> list) {
        Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> enchants = EnchantmentTrait.getEnchantmentsOnGear(gear);
        for (EnchantmentData data : list) {
            Enchantment enchantment = data.getEnchantment();
            if (enchantment == null || enchants.containsKey(enchantment)) continue;
            boolean compatible = true;
            for (Enchantment current : enchants.keySet()) {
                if (current.m_44695_(enchantment)) continue;
                compatible = false;
                break;
            }
            if (!compatible) continue;
            int enchantmentLevel = data.getLevel(traitLevel);
            enchants.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)enchantmentLevel, (Object)this.getId(), (Object)traitLevel));
            SilentGear.LOGGER.debug("Adding {} enchantment from {} trait to {}", (Object)enchantment.m_44700_(enchantmentLevel).getString(), (Object)this.getDisplayName(traitLevel).getString(), (Object)gear.m_41786_().getString());
        }
        EnchantmentTrait.setEnchantmentsOnGear(gear, enchants);
    }

    private static Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> getEnchantmentsOnGear(ItemStack gear) {
        LinkedHashMap<Enchantment, Triple<Integer, ResourceLocation, Integer>> map = new LinkedHashMap<Enchantment, Triple<Integer, ResourceLocation, Integer>>();
        ListTag tagList = gear.m_41785_();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbt = tagList.m_128728_(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.m_128461_("id")));
            if (enchantment == null) continue;
            int level = nbt.m_128451_("lvl");
            String traitKey = nbt.m_128461_("SGearTrait");
            if (!traitKey.isEmpty()) {
                try {
                    String[] parts = traitKey.split("#");
                    ResourceLocation traitId = new ResourceLocation(parts[0]);
                    Integer traitLevel = Integer.valueOf(parts[1]);
                    map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)traitId, (Object)traitLevel));
                }
                catch (Exception ex) {
                    map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)new ResourceLocation("null"), (Object)0));
                }
                continue;
            }
            map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)new ResourceLocation("null"), (Object)0));
        }
        return map;
    }

    private static void setEnchantmentsOnGear(ItemStack gear, Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> map) {
        ListTag tagList = new ListTag();
        for (Map.Entry<Enchantment, Triple<Integer, ResourceLocation, Integer>> entry : map.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int level = (Integer)entry.getValue().getLeft();
            ResourceLocation traitId = (ResourceLocation)entry.getValue().getMiddle();
            int traitLevel = (Integer)entry.getValue().getRight();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("id", NameUtils.from((IForgeRegistryEntry)enchantment).toString());
            nbt.m_128376_("lvl", (short)level);
            if (traitLevel > 0) {
                nbt.m_128359_("SGearTrait", traitId + "#" + traitLevel);
            }
            tagList.add((Object)nbt);
        }
        if (tagList.isEmpty()) {
            gear.m_41749_("Enchantments");
        } else {
            gear.m_41700_("Enchantments", (Tag)tagList);
        }
    }

    private static void readJson(EnchantmentTrait trait, JsonObject json) {
        if (!json.has("enchantments")) {
            throw new JsonParseException("Enchantment trait '" + trait.getId() + "' is missing 'enchantments' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("enchantments");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(EnchantmentData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.enchantments.put(key, list);
        }
    }

    private static void readBuffer(EnchantmentTrait trait, FriendlyByteBuf buffer) {
        trait.enchantments.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
            String gearType = buffer.m_130277_();
            int dataCount = buffer.readByte();
            for (int dataIndex = 0; dataIndex < dataCount; ++dataIndex) {
                list.add(EnchantmentData.read(buffer));
            }
            trait.enchantments.put(gearType, list);
        }
    }

    private static void writeBuffer(EnchantmentTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.enchantments.size());
        for (Map.Entry<String, List<EnchantmentData>> entry : trait.enchantments.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (EnchantmentData data : entry.getValue()) {
                data.write(buffer);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.enchantments.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class EnchantmentData {
        private ResourceLocation enchantmentId;
        private int[] levels;

        public static EnchantmentData of(Enchantment enchantment, int ... levels) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = enchantment.getRegistryName();
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("enchantment", this.enchantmentId.toString());
            JsonArray levelsJson = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsJson).add(arg_0));
            json.add("level", (JsonElement)levelsJson);
            return json;
        }

        static EnchantmentData from(JsonObject json) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"enchantment", (String)"unknown"));
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        static EnchantmentData read(FriendlyByteBuf buffer) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = buffer.m_130281_();
            ret.levels = buffer.m_130100_();
            return ret;
        }

        void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.enchantmentId);
            buffer.m_130089_(this.levels);
        }

        @Nullable
        Enchantment getEnchantment() {
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.enchantmentId);
        }

        int getLevel(int traitLevel) {
            int index = Mth.m_14045_((int)traitLevel, (int)1, (int)this.levels.length) - 1;
            return this.levels[index];
        }

        public String getWikiLine() {
            CharSequence[] levelsText = new String[this.levels.length];
            for (int i = 0; i < this.levels.length; ++i) {
                levelsText[i] = Integer.toString(this.levels[i]);
            }
            return this.enchantmentId + ": [" + String.join((CharSequence)", ", levelsText) + "]";
        }
    }
}

