/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;

public final class NBTTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("nbt");
    static final ITraitSerializer<NBTTrait> SERIALIZER = new SimpleTrait.Serializer<NBTTrait>(SERIALIZER_ID, NBTTrait::new, NBTTrait::readJson, NBTTrait::readBuffer, NBTTrait::writeBuffer);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, List<DataEntry>> data = new HashMap<String, List<DataEntry>>();

    private NBTTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
        ItemStack gear = context.getGear();
        GearType gearType = GearHelper.getType(gear);
        int traitLevel = context.getTraitLevel();
        this.data.forEach((type, list) -> {
            if (gearType.matches((String)type) || "all".equals(type)) {
                list.stream().filter(e -> e.level == traitLevel).forEach(e -> gear.m_41784_().m_128391_(e.data));
            }
        });
    }

    private static void readJson(NBTTrait trait, JsonObject json) {
        if (!json.has("nbt")) {
            throw new JsonParseException("NBT trait '" + trait.getId() + "' is missing 'nbt' object");
        }
        JsonObject jsonNbt = json.getAsJsonObject("nbt");
        for (Map.Entry entry : jsonNbt.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<DataEntry> list = new ArrayList<DataEntry>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(DataEntry.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.data.put(key, list);
        }
    }

    private static void readBuffer(NBTTrait trait, FriendlyByteBuf buffer) {
        trait.data.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<DataEntry> list = new ArrayList<DataEntry>();
            String gearType = buffer.m_130277_();
            int dataCount = buffer.readByte();
            for (int dataIndex = 0; dataIndex < dataCount; ++dataIndex) {
                list.add(DataEntry.read(buffer));
            }
            trait.data.put(gearType, list);
        }
    }

    private static void writeBuffer(NBTTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.data.size());
        trait.data.forEach((type, list) -> {
            buffer.m_130070_(type);
            buffer.writeByte(list.size());
            list.forEach(e -> e.write(buffer));
        });
    }

    public static class DataEntry {
        private int level;
        private CompoundTag data = new CompoundTag();

        static DataEntry from(JsonObject json) {
            DataEntry ret = new DataEntry();
            ret.level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
            try {
                JsonElement element = json.get("data");
                ret.data = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)json, (String)"data"));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return ret;
        }

        static DataEntry read(FriendlyByteBuf buffer) {
            DataEntry ret = new DataEntry();
            ret.level = buffer.readByte();
            ret.data = buffer.m_130260_();
            return ret;
        }

        void write(FriendlyByteBuf buffer) {
            buffer.writeByte(this.level);
            buffer.m_130079_(this.data);
        }
    }
}

