/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public final class StatModifierTrait
extends SimpleTrait {
    public static final ITraitSerializer<StatModifierTrait> SERIALIZER = new SimpleTrait.Serializer<StatModifierTrait>(SilentGear.getId("stat_modifier"), StatModifierTrait::new, StatModifierTrait::readJson, StatModifierTrait::readBuffer, StatModifierTrait::writeBuffer);
    private final Map<ItemStat, StatMod> mods = new HashMap<ItemStat, StatMod>();

    private StatModifierTrait(ResourceLocation name) {
        super(name, SERIALIZER);
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        StatMod mod = this.mods.get(stat);
        if (mod != null) {
            return mod.apply(context.getTraitLevel(), value, damageRatio);
        }
        return value;
    }

    private static void readJson(StatModifierTrait trait, JsonObject json) {
        if (!json.has("stats")) {
            SilentGear.LOGGER.error("JSON file for StatModifierTrait '{}' is missing the 'stats' array", (Object)trait.getId());
            return;
        }
        for (JsonElement element : json.get("stats").getAsJsonArray()) {
            JsonObject obj;
            String statName;
            ItemStat stat;
            if (!element.isJsonObject() || (stat = ItemStats.byName(statName = GsonHelper.m_13851_((JsonObject)(obj = element.getAsJsonObject()), (String)"name", (String)""))) == null) continue;
            trait.mods.put(stat, StatMod.fromJson(obj));
        }
    }

    private static void readBuffer(StatModifierTrait trait, FriendlyByteBuf buffer) {
        trait.mods.clear();
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            ItemStat stat = (ItemStat)((IForgeRegistry)ItemStats.REGISTRY.get()).getValue(buffer.m_130281_());
            trait.mods.put(stat, StatMod.read(buffer));
        }
    }

    private static void writeBuffer(StatModifierTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.mods.size());
        trait.mods.forEach((stat, mod) -> {
            buffer.m_130085_(Objects.requireNonNull(stat.getRegistryName()));
            mod.write(buffer);
        });
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.mods.forEach((stat, mod) -> ret.add("  - " + stat.getDisplayName().getString() + ": " + mod.multi + " * level" + (mod.factorDamage ? " * damage" : "") + (mod.factorValue ? " * value" : "")));
        return ret;
    }

    public static class StatMod {
        private float multi;
        private boolean factorDamage;
        private boolean factorValue;

        public static StatMod of(float multi, boolean factorDamage, boolean factorValue) {
            StatMod ret = new StatMod();
            ret.multi = multi;
            ret.factorDamage = factorDamage;
            ret.factorValue = factorValue;
            return ret;
        }

        private float apply(int level, float value, float damageRatio) {
            float f = this.multi * (float)level;
            if (this.factorDamage) {
                f *= damageRatio;
            }
            if (this.factorValue) {
                f *= value;
            }
            return value + f;
        }

        public JsonObject serialize(IItemStat stat) {
            JsonObject json = new JsonObject();
            json.addProperty("name", stat.getStatId().toString());
            json.addProperty("value", (Number)Float.valueOf(this.multi));
            json.addProperty("factor_damage", Boolean.valueOf(this.factorDamage));
            json.addProperty("factor_value", Boolean.valueOf(this.factorValue));
            return json;
        }

        private static StatMod fromJson(JsonObject json) {
            StatMod mod = new StatMod();
            mod.multi = GsonHelper.m_13820_((JsonObject)json, (String)"value", (float)0.0f);
            mod.factorDamage = GsonHelper.m_13855_((JsonObject)json, (String)"factor_damage", (boolean)true);
            mod.factorValue = GsonHelper.m_13855_((JsonObject)json, (String)"factor_value", (boolean)true);
            return mod;
        }

        private static StatMod read(FriendlyByteBuf buffer) {
            StatMod mod = new StatMod();
            mod.multi = buffer.readFloat();
            mod.factorDamage = buffer.readBoolean();
            mod.factorValue = buffer.readBoolean();
            return mod;
        }

        private void write(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.multi);
            buffer.writeBoolean(this.factorDamage);
            buffer.writeBoolean(this.factorValue);
        }
    }
}

