/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public class SynergyTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("synergy");
    public static final ITraitSerializer<SynergyTrait> SERIALIZER = new SimpleTrait.Serializer<SynergyTrait>(SERIALIZER_ID, SynergyTrait::new, SynergyTrait::deserialize, SynergyTrait::read, SynergyTrait::write);
    private float multi = 0.0f;
    private float rangeMin = 0.0f;
    private float rangeMax = Float.MAX_VALUE;

    public SynergyTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public double apply(double synergy, int traitLevel) {
        if (synergy > (double)this.rangeMin && synergy < (double)this.rangeMax) {
            return synergy + (double)((float)traitLevel * this.multi);
        }
        return synergy;
    }

    private static void deserialize(SynergyTrait trait, JsonObject json) {
        trait.multi = GsonHelper.m_13915_((JsonObject)json, (String)"synergy_multi");
        if (json.has("applicable_range")) {
            JsonObject range = json.get("applicable_range").getAsJsonObject();
            trait.rangeMin = GsonHelper.m_13820_((JsonObject)range, (String)"min", (float)trait.rangeMin);
            trait.rangeMax = GsonHelper.m_13820_((JsonObject)range, (String)"max", (float)trait.rangeMax);
        }
    }

    private static void read(SynergyTrait trait, FriendlyByteBuf buffer) {
        trait.multi = buffer.readFloat();
        trait.rangeMin = buffer.readFloat();
        trait.rangeMax = buffer.readFloat();
    }

    private static void write(SynergyTrait trait, FriendlyByteBuf buffer) {
        buffer.writeFloat(trait.multi);
        buffer.writeFloat(trait.rangeMin);
        buffer.writeFloat(trait.rangeMax);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Please read [this page](https://github.com/SilentChaos512/Silent-Gear/wiki/Synergy) for more information on synergy");
        String multiStr = "  - " + (String)(this.multi > 0.0f ? "+" + this.multi : String.valueOf(this.multi));
        String str = this.rangeMax < Float.MAX_VALUE ? multiStr + " synergy if between " + SynergyTrait.formatPercent(this.rangeMin) + " and " + SynergyTrait.formatPercent(this.rangeMax) : multiStr + " synergy if greater than " + SynergyTrait.formatPercent(this.rangeMin);
        ret.add(str);
        return ret;
    }

    private static String formatPercent(float value) {
        return (int)(value * 100.0f) + "%";
    }
}

