/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.function.BiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.renderer.entity.GearArrowRenderer;
import net.silentchaos512.gear.client.renderer.entity.GearFishingHookRenderer;
import net.silentchaos512.gear.client.renderer.entity.RenderSlingshotProjectile;
import net.silentchaos512.gear.entity.GearFishingHook;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;
import net.silentchaos512.gear.entity.projectile.SlingshotProjectile;
import net.silentchaos512.gear.init.Registration;

public final class ModEntities {
    public static final RegistryObject<EntityType<GearArrowEntity>> ARROW = ModEntities.register("arrow", GearArrowEntity::new, MobCategory.MISC, GearArrowEntity::new);
    public static final RegistryObject<EntityType<GearFishingHook>> FISHING_HOOK = ModEntities.register("fishing_hook", GearFishingHook::new, MobCategory.MISC, GearFishingHook::new);
    public static final RegistryObject<EntityType<SlingshotProjectile>> SLINGSHOT_PROJECTILE = ModEntities.register("slingshot_projectile", SlingshotProjectile::new, MobCategory.MISC, SlingshotProjectile::new);

    private ModEntities() {
        throw new IllegalAccessError("Utility class");
    }

    static void register() {
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.EntityFactory<T> factory, MobCategory type, BiFunction<PlayMessages.SpawnEntity, Level, T> customClientFactory) {
        return Registration.ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)type).setCustomClientFactory(customClientFactory).m_20712_(SilentGear.getId(name).toString()));
    }

    @Mod.EventBusSubscriber(modid="silentgear", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Events {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ARROW.get(), GearArrowRenderer::new);
            event.registerEntityRenderer((EntityType)FISHING_HOOK.get(), GearFishingHookRenderer::new);
            event.registerEntityRenderer((EntityType)SLINGSHOT_PROJECTILE.get(), RenderSlingshotProjectile::new);
        }
    }
}

