/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.init.GearEnchantments;
import net.silentchaos512.gear.init.GearVillages;
import net.silentchaos512.gear.init.ModBlockEntities;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModEntities;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.init.ModRecipes;

public final class Registration {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = Registration.create(ForgeRegistries.BLOCK_ENTITIES);
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<MenuType<?>> CONTAINERS = Registration.create(ForgeRegistries.CONTAINERS);
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = Registration.create(ForgeRegistries.ENCHANTMENTS);
    public static final DeferredRegister<EntityType<?>> ENTITIES = Registration.create(ForgeRegistries.ENTITIES);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIERS = Registration.create(ForgeRegistries.LOOT_MODIFIER_SERIALIZERS);
    public static final DeferredRegister<PoiType> POINTS_OF_INTEREST = Registration.create(ForgeRegistries.POI_TYPES);
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = Registration.create(ForgeRegistries.PROFESSIONS);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registration.create(ForgeRegistries.RECIPE_SERIALIZERS);

    private Registration() {
        throw new IllegalAccessError("Utility class");
    }

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_ENTITIES.register(modEventBus);
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENCHANTMENTS.register(modEventBus);
        ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
        LOOT_MODIFIERS.register(modEventBus);
        POINTS_OF_INTEREST.register(modEventBus);
        PROFESSIONS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        ModBlockEntities.register();
        ModBlocks.register();
        ModContainers.register();
        GearEnchantments.register();
        ModEntities.register();
        ModItems.register();
        ModLootStuff.init();
        ModRecipes.register();
        GearVillages.register();
    }

    public static <T extends Block> Collection<T> getBlocks(Class<T> clazz) {
        return BLOCKS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(block -> block).collect(Collectors.toList());
    }

    public static <T> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(item -> item).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(predicate).collect(Collectors.toList());
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"silentgear");
    }
}

