/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.model.ModelErrorLogging;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearArmorItem
extends DyeableArmorItem
implements ICoreArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final float[] ABSORPTION_RATIO_BY_SLOT = new float[]{0.15f, 0.3f, 0.4f, 0.15f};
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private static final Cache<String, Integer> ARMOR_COLORS = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public GearArmorItem(EquipmentSlot slot) {
        super((ArmorMaterial)ArmorMaterials.DIAMOND, slot, GearHelper.getBaseItemProperties());
    }

    @Deprecated
    public GearArmorItem(EquipmentSlot slot, String name) {
        this(slot);
    }

    @Override
    public GearType getGearType() {
        switch (this.m_40402_()) {
            case HEAD: {
                return GearType.HELMET;
            }
            case CHEST: {
                return GearType.CHESTPLATE;
            }
            case LEGS: {
                return GearType.LEGGINGS;
            }
            case FEET: {
                return GearType.BOOTS;
            }
        }
        throw new IllegalStateException("Don't know the gear type for " + this.getRegistryName());
    }

    @Override
    public boolean isValidSlot(String slot) {
        return this.m_40402_().m_20751_().equalsIgnoreCase(slot);
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return MAX_DAMAGE_ARRAY[this.m_40402_().m_20749_()];
    }

    public double getArmorProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.ARMOR);
    }

    public double getArmorToughness(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.ARMOR_TOUGHNESS);
    }

    public double getArmorMagicProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.MAGIC_ARMOR);
    }

    private static double getGenericArmorProtection(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof GearArmorItem) {
            return ((GearArmorItem)item).getArmorProtection(stack);
        }
        if (item instanceof ArmorItem) {
            return ((ArmorItem)item).m_40404_();
        }
        return 0.0;
    }

    private static int getPlayerTotalArmorValue(LivingEntity player) {
        float total = 0.0f;
        for (ItemStack armor : player.m_6168_()) {
            total = (float)((double)total + GearArmorItem.getGenericArmorProtection(armor));
        }
        return Math.round(total);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (slot == this.m_40402_()) {
            UUID uuid = ARMOR_MODIFIERS[slot.m_20749_()];
            multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", this.getArmorProtection(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", this.getArmorToughness(stack), AttributeModifier.Operation.ADDITION));
            float knockbackResistance = GearData.getStat(stack, ItemStats.KNOCKBACK_RESISTANCE) / 10.0f;
            if (knockbackResistance > 0.0f) {
                multimap.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
            }
            return GearHelper.getAttributeModifiers(slot, stack, (Multimap<Attribute, AttributeModifier>)multimap);
        }
        return multimap;
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = GearData.getStatInt(stack, this.getDurabilityStat());
        return MAX_DAMAGE_ARRAY[this.m_40402_().m_20749_()] * maxDamageFactor;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.m_14045_((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, t -> {
            GearHelper.onBroken(stack, t instanceof Player ? (Player)t : null, this.m_40402_());
            onBroken.accept(t);
        });
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        GearHelper.inventoryTick(stack, world, (Entity)player, 0, true);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        int layer;
        if (GearHelper.isBroken(stack)) {
            return "silentgear:textures/models/armor/empty.png";
        }
        int n = layer = slot == EquipmentSlot.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "silentgear:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        MaterialInstance material = GearData.getPrimaryArmorMaterial(stack);
        if (material != null) {
            IMaterialDisplay materialModel = material.getDisplayProperties();
            PartType partType = GearData.hasPartOfType(stack, PartType.COATING) ? PartType.COATING : PartType.MAIN;
            MaterialLayer materialLayer = materialModel.getLayerList(this.getGearType(), partType, (IMaterialInstance)material).getFirstLayer();
            if (materialLayer != null) {
                ResourceLocation tex = materialLayer.getTextureId();
                return tex.m_135827_() + ":textures/models/armor/" + tex.m_135815_() + "_layer_" + layer + (String)(type != null ? "_" + type : "") + ".png";
            }
        }
        return "silentgear:textures/models/armor/main_generic_hc_layer_" + layer + (String)(type != null ? "_" + type : "") + ".png";
    }

    public boolean m_41113_(ItemStack stack) {
        return true;
    }

    public int m_41121_(ItemStack stack) {
        try {
            return (Integer)ARMOR_COLORS.get((Object)GearData.getModelKey(stack, 0), () -> GearArmorItem.getArmorColor(stack));
        }
        catch (ExecutionException e) {
            ModelErrorLogging.notifyOfException(e, "armor model");
            return 0xFFFFFF;
        }
    }

    private static int getArmorColor(ItemStack stack) {
        PartData part = GearData.getCoatingOrMainPart(stack);
        if (part != null) {
            return part.getColor(stack);
        }
        return 0xFFFFFF;
    }

    public void m_41123_(ItemStack stack) {
    }

    public void m_41115_(ItemStack stack, int color) {
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

