/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.item.gear.GearDiggerItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearPickaxeItem
extends GearDiggerItem {
    private static final Set<Material> PICKAXE_EXTRA_MATERIALS = ImmutableSet.of((Object)Material.f_76278_, (Object)Material.f_76279_, (Object)Material.f_76281_, (Object)Material.f_76276_, (Object)Material.f_76316_, (Object)Material.f_76275_, (Object[])new Material[]{Material.f_76312_, Material.f_76283_, Material.f_76310_});
    public static final Set<ToolAction> ACTIONS_WITH_SPOON = GearHelper.makeToolActionSet(ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG);

    public GearPickaxeItem(GearType gearType) {
        this(gearType, PICKAXE_EXTRA_MATERIALS);
    }

    public GearPickaxeItem(GearType gearType, Set<Material> extraMaterials) {
        super(gearType, (Tag<Block>)BlockTags.f_144282_, extraMaterials, GearHelper.getBaseItemProperties());
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (GearHelper.isBroken(stack)) {
            return false;
        }
        if (TraitHelper.hasTrait(stack, Const.Traits.SPOON)) {
            return ACTIONS_WITH_SPOON.contains(toolAction);
        }
        return super.canPerformAction(stack, toolAction);
    }
}

