/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.loot.condition.GearLootCondition;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class HasTraitCondition
extends GearLootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation traitId;
    private final int minLevel;
    private final int maxLevel;

    public HasTraitCondition(ResourceLocation traitId, int minLevel, int maxLevel) {
        this.traitId = traitId;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public boolean test(LootContext context) {
        ItemStack tool = HasTraitCondition.getItemUsed(context);
        if (!GearHelper.isGear(tool)) {
            return false;
        }
        int level = TraitHelper.getTraitLevel(tool, this.traitId);
        return level >= this.minLevel && level <= this.maxLevel;
    }

    public static LootItemCondition.Builder builder(ResourceLocation traitId) {
        return HasTraitCondition.builder(traitId, 1, Integer.MAX_VALUE);
    }

    public static LootItemCondition.Builder builder(ResourceLocation traitId, int minLevel) {
        return HasTraitCondition.builder(traitId, minLevel, Integer.MAX_VALUE);
    }

    public static LootItemCondition.Builder builder(ResourceLocation traitId, int minLevel, int maxLevel) {
        return () -> new HasTraitCondition(traitId, minLevel, maxLevel);
    }

    public LootItemConditionType m_7940_() {
        return ModLootStuff.HAS_TRAIT;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<HasTraitCondition> {
        public void serialize(JsonObject json, HasTraitCondition value, JsonSerializationContext context) {
            json.addProperty("trait", value.traitId.toString());
        }

        public HasTraitCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation traitId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"trait"));
            int minLevel = 1;
            int maxLevel = Integer.MAX_VALUE;
            if (json.has("level")) {
                JsonElement levelJson = json.get("level");
                if (levelJson.isJsonPrimitive()) {
                    minLevel = levelJson.getAsInt();
                } else {
                    minLevel = GsonHelper.m_13824_((JsonObject)levelJson.getAsJsonObject(), (String)"min", (int)minLevel);
                    maxLevel = GsonHelper.m_13824_((JsonObject)levelJson.getAsJsonObject(), (String)"max", (int)maxLevel);
                }
            }
            return new HasTraitCondition(traitId, minLevel, maxLevel);
        }
    }
}

