/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.function;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.util.GearData;

public final class SetPartsFunction
extends LootItemConditionalFunction {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<LazyPartData> parts;

    private SetPartsFunction(LootItemCondition[] conditions, List<LazyPartData> parts) {
        super(conditions);
        this.parts = parts;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (!(stack.m_41720_() instanceof ICoreItem)) {
            return stack;
        }
        ItemStack result = stack.m_41777_();
        List<PartData> parts = LazyPartData.createPartList(this.parts);
        parts.forEach(p -> p.onAddToGear(result));
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result, null);
        return result;
    }

    public static LootItemConditionalFunction.Builder<?> builder(List<LazyPartData> parts) {
        return SetPartsFunction.m_80683_(conditions -> new SetPartsFunction((LootItemCondition[])conditions, parts));
    }

    public LootItemFunctionType m_7162_() {
        return ModLootStuff.SET_PARTS;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetPartsFunction> {
        public void serialize(JsonObject json, SetPartsFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            JsonArray array = new JsonArray();
            function.parts.forEach(part -> array.add((JsonElement)part.serialize()));
            json.add("parts", (JsonElement)array);
        }

        public SetPartsFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditionsIn) {
            ArrayList<LazyPartData> parts = new ArrayList<LazyPartData>();
            JsonArray partsArray = Objects.requireNonNull(GsonHelper.m_13832_((JsonObject)json, (String)"parts", (JsonArray)new JsonArray()));
            for (JsonElement jsonElement : partsArray) {
                parts.add(LazyPartData.deserialize(jsonElement));
            }
            return new SetPartsFunction(conditionsIn, parts);
        }
    }
}

