/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.modifier;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class BonusDropsTraitLootModifier
extends LootModifier {
    public BonusDropsTraitLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(generatedLoot);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (tool != null && GearHelper.isGear(tool)) {
            TraitHelper.activateTraits(tool, 0.0f, (trait, level, value) -> {
                generatedLoot.forEach(lootStack -> {
                    ItemStack stack = trait.addLootDrops(new TraitActionContext(null, level, tool), (ItemStack)lootStack);
                    if (!stack.m_41619_()) {
                        ret.add(stack);
                    }
                });
                return 0.0f;
            });
        }
        return ret;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BonusDropsTraitLootModifier> {
        public BonusDropsTraitLootModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
            return new BonusDropsTraitLootModifier(conditionsIn);
        }

        public JsonObject write(BonusDropsTraitLootModifier instance) {
            return new JsonObject();
        }
    }
}

