/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitManager;

public final class DataResource<T> {
    private final ResourceLocation objectId;
    private final Function<ResourceLocation, T> getter;

    public DataResource(ResourceLocation id, Function<ResourceLocation, T> getter) {
        this.objectId = id;
        this.getter = getter;
    }

    public static DataResource<IMaterial> material(String modPath) {
        return DataResource.material(SilentGear.getId(modPath));
    }

    public static DataResource<IMaterial> material(ResourceLocation id) {
        return new DataResource<IMaterial>(id, MaterialManager::get);
    }

    public static DataResource<IGearPart> part(String modPath) {
        return DataResource.part(SilentGear.getId(modPath));
    }

    public static DataResource<IGearPart> part(ResourceLocation id) {
        return new DataResource<IGearPart>(id, PartManager::get);
    }

    public static DataResource<ITrait> trait(String modPath) {
        return DataResource.trait(SilentGear.getId(modPath));
    }

    public static DataResource<ITrait> trait(ResourceLocation id) {
        return new DataResource<ITrait>(id, TraitManager::get);
    }

    @Nullable
    private T getNullable() {
        return this.getter.apply(this.objectId);
    }

    public T get() {
        T ret = this.getNullable();
        Objects.requireNonNull(ret, () -> "Data resource not present: " + this.objectId);
        return ret;
    }

    public ResourceLocation getId() {
        return this.objectId;
    }

    public boolean isPresent() {
        return this.getNullable() != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        T obj = this.getNullable();
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        T obj = this.getNullable();
        return obj != null ? Optional.ofNullable(mapper.apply(obj)) : Optional.empty();
    }
}

