/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.api.GearApi;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.Const;

public interface IAoeTool {
    default public int getAoeRadius(ItemStack stack) {
        return 1 + GearApi.getTraitLevel(stack, Const.Traits.WIDEN);
    }

    @Nullable
    public HitResult rayTraceBlocks(Level var1, Player var2);

    default public List<BlockPos> getExtraBlocks(Level world, @Nullable BlockHitResult rt, Player player, ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (player.m_6047_() || rt == null || rt.m_82425_() == null || rt.m_82434_() == null) {
            return positions;
        }
        BlockPos pos = rt.m_82425_();
        BlockState state = world.m_8055_(pos);
        if (this.isEffectiveOnBlock(stack, state, player)) {
            Direction dir1;
            Direction dir2 = switch (rt.m_82434_().m_122434_()) {
                case Direction.Axis.Y -> {
                    dir1 = Direction.SOUTH;
                    yield Direction.EAST;
                }
                case Direction.Axis.X -> {
                    dir1 = Direction.UP;
                    yield Direction.SOUTH;
                }
                default -> {
                    dir1 = Direction.UP;
                    yield Direction.EAST;
                }
            };
            int r = this.getAoeRadius(stack);
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    if (i == 0 && j == 0) continue;
                    this.attemptAddExtraBlock(world, state, pos.m_5484_(dir1, i).m_5484_(dir2, j), stack, player, positions);
                }
            }
        }
        return positions;
    }

    default public boolean isEffectiveOnBlock(ItemStack stack, BlockState state, Player player) {
        boolean isCorrectTool = stack.m_41720_().isCorrectToolForDrops(stack, state) || ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
        return isCorrectTool && stack.m_41691_(state) > 1.0f;
    }

    default public void attemptAddExtraBlock(Level world, BlockState state, BlockPos pos, ItemStack stack, Player player, List<BlockPos> list) {
        BlockState state1 = world.m_8055_(pos);
        if (state1.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return;
        }
        if (!world.m_46859_(pos) && BreakHandler.areBlocksSimilar(state, state1) && this.isEffectiveOnBlock(stack, state1, player)) {
            list.add(pos);
        }
    }

    public static final class BreakHandler {
        private BreakHandler() {
        }

        public static boolean onBlockStartBreak(ItemStack tool, BlockPos pos, Player player) {
            Level world = player.m_20193_();
            if (world.f_46443_ || !(world instanceof ServerLevel) || !(player instanceof ServerPlayer) || !(tool.m_41720_() instanceof IAoeTool)) {
                return false;
            }
            IAoeTool item = (IAoeTool)tool.m_41720_();
            HitResult rt = item.rayTraceBlocks(world, player);
            BlockState stateOriginal = world.m_8055_(pos);
            if (rt != null && rt.m_6662_() == HitResult.Type.BLOCK && item.isEffectiveOnBlock(tool, stateOriginal, player)) {
                BlockHitResult brt = (BlockHitResult)rt;
                Direction side = brt.m_82434_();
                List<BlockPos> extraBlocks = item.getExtraBlocks(world, brt, player, tool);
                for (BlockPos pos2 : extraBlocks) {
                    BlockState state = world.m_8055_(pos2);
                    if (!world.m_46805_(pos2) || !player.m_36204_(pos2, side, tool) || !state.canHarvestBlock((BlockGetter)world, pos2, player)) continue;
                    if (player.m_150110_().f_35937_) {
                        if (state.onDestroyedByPlayer(world, pos2, player, true, state.m_60819_())) {
                            state.m_60734_().m_6786_((LevelAccessor)world, pos2, state);
                        }
                    } else {
                        int xp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos2);
                        if (xp == -1) continue;
                        tool.m_41720_().m_6813_(tool, world, state, pos2, (LivingEntity)player);
                        BlockEntity tileEntity = world.m_7702_(pos2);
                        if (state.onDestroyedByPlayer(world, pos2, player, true, state.m_60819_())) {
                            state.m_60734_().m_6786_((LevelAccessor)world, pos2, state);
                            state.m_60734_().m_6240_(world, player, pos2, state, tileEntity, tool);
                            state.m_60734_().m_49805_((ServerLevel)world, pos2, xp);
                        }
                    }
                    ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
                }
            }
            return false;
        }

        static boolean areBlocksSimilar(BlockState state1, BlockState state2) {
            int level2;
            MatchMode mode;
            Block block1 = state1.m_60734_();
            Block block2 = state2.m_60734_();
            boolean isOre1 = BreakHandler.isOre(state1);
            boolean isOre2 = BreakHandler.isOre(state2);
            MatchMode matchMode = mode = isOre1 && isOre2 ? (MatchMode)((Object)Config.Common.matchModeOres.get()) : (MatchMode)((Object)Config.Common.matchModeStandard.get());
            if (mode == MatchMode.LOOSE || block1 == block2) {
                return true;
            }
            if (mode == MatchMode.STRICT || !isOre1 && isOre2) {
                return false;
            }
            int level1 = BreakHandler.guessHarvestLevel(state1);
            return level1 >= (level2 = BreakHandler.guessHarvestLevel(state2)) || level2 == 0;
        }

        private static boolean isOre(BlockState state) {
            return state.m_60620_((Tag)Tags.Blocks.ORES);
        }

        private static int guessHarvestLevel(BlockState state) {
            if (state.m_60620_((Tag)Tags.Blocks.NEEDS_NETHERITE_TOOL)) {
                return 4;
            }
            if (state.m_60620_((Tag)BlockTags.f_144284_)) {
                return 3;
            }
            if (state.m_60620_((Tag)BlockTags.f_144285_)) {
                return 2;
            }
            if (state.m_60620_((Tag)BlockTags.f_144286_)) {
                return 1;
            }
            return 0;
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
    public static final class HighlightHandler {
        private HighlightHandler() {
        }

        private static void drawSelectionBox(PoseStack matrixStackIn, Level world, VertexConsumer bufferIn, Entity entityIn, double xIn, double yIn, double zIn, BlockPos blockPosIn, BlockState blockStateIn) {
            HighlightHandler.drawShape(matrixStackIn, bufferIn, blockStateIn.m_60651_((BlockGetter)world, blockPosIn, CollisionContext.m_82750_((Entity)entityIn)), (double)blockPosIn.m_123341_() - xIn, (double)blockPosIn.m_123342_() - yIn, (double)blockPosIn.m_123343_() - zIn, 0.0f, 0.0f, 0.0f, 0.4f);
        }

        private static void drawShape(PoseStack matrixStackIn, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            shapeIn.m_83224_((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
                bufferIn.m_85982_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).m_85950_(red, green, blue, alpha).m_5752_();
                bufferIn.m_85982_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).m_85950_(red, green, blue, alpha).m_5752_();
            });
        }
    }

    public static enum MatchMode {
        LOOSE,
        MODERATE,
        STRICT;

    }
}

