/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetTraitsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static float activateTraits(ItemStack gear, float inputValue, TraitFunction action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        ListTag tagList = GearData.getPropertiesData(gear).m_128437_("Traits", 10);
        float value = inputValue;
        for (Tag nbt : tagList) {
            CompoundTag tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof CompoundTag) || (trait = TraitManager.get(regName = (tagCompound = (CompoundTag)nbt).m_128461_("Name"))) == null) continue;
            byte level = tagCompound.m_128445_("Level");
            value = action.apply(trait, level, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ITrait trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListTag tagList = GearData.getPropertiesData(gear).m_128437_("Traits", 10);
            for (Tag nbt : tagList) {
                CompoundTag tagCompound;
                String regName;
                if (!(nbt instanceof CompoundTag) || !(regName = (tagCompound = (CompoundTag)nbt).m_128461_("Name")).equals(traitId.toString())) continue;
                return tagCompound.m_128445_("Level");
            }
        }
        return 0;
    }

    public static boolean hasTrait(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ITrait trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListTag tagList = GearData.getPropertiesData(gear).m_128437_("Traits", 10);
            for (Tag nbt : tagList) {
                CompoundTag tagCompound;
                String regName;
                if (!(nbt instanceof CompoundTag) || !(regName = (tagCompound = (CompoundTag)nbt).m_128461_("Name")).equals(traitId.toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int getHighestLevelEitherHand(Player player, DataResource<ITrait> trait) {
        return TraitHelper.getHighestLevelEitherHand(player, trait.getId());
    }

    @Deprecated
    public static int getHighestLevelEitherHand(Player player, ResourceLocation traitId) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return Math.max(TraitHelper.getTraitLevel(main, traitId), TraitHelper.getTraitLevel(off, traitId));
    }

    public static int getHighestLevelArmor(Player player, DataResource<ITrait> trait) {
        int max = 0;
        for (ItemStack stack : player.m_150109_().f_35975_) {
            max = Math.max(max, TraitHelper.getTraitLevel(stack, trait));
        }
        return max;
    }

    public static int getHighestLevelCurio(LivingEntity entity, DataResource<ITrait> trait) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getHighestTraitLevel(entity, trait);
        }
        return 0;
    }

    public static int getHighestLevelArmorOrCurio(Player player, DataResource<ITrait> trait) {
        return Math.max(TraitHelper.getHighestLevelArmor(player, trait), TraitHelper.getHighestLevelCurio((LivingEntity)player, trait));
    }

    public static boolean hasTraitEitherHand(Player player, DataResource<ITrait> trait) {
        return TraitHelper.hasTraitEitherHand(player, trait.getId());
    }

    @Deprecated
    public static boolean hasTraitEitherHand(Player player, ResourceLocation traitId) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return TraitHelper.hasTrait(main, traitId) || TraitHelper.hasTrait(off, traitId);
    }

    public static boolean hasTraitArmor(Player player, DataResource<ITrait> trait) {
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (!TraitHelper.hasTrait(stack, trait)) continue;
            return true;
        }
        return false;
    }

    public static Map<ITrait, Integer> getCachedTraits(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        ListTag tagList = GearData.getPropertiesData(gear).m_128437_("Traits", 10);
        for (Tag nbt : tagList) {
            if (!(nbt instanceof CompoundTag)) continue;
            CompoundTag tagCompound = (CompoundTag)nbt;
            String name = tagCompound.m_128461_("Name");
            ITrait trait = TraitManager.get(name);
            byte level = tagCompound.m_128445_("Level");
            if (trait == null || level <= 0) continue;
            result.put(trait, Integer.valueOf(level));
        }
        return result;
    }

    @Deprecated
    public static Map<ITrait, Integer> getTraits(ItemStack gear, PartDataList parts) {
        return TraitHelper.getTraits(gear, GearHelper.getType(gear), parts);
    }

    public static Map<ITrait, Integer> getTraits(ItemStack gear, GearType gearType, PartDataList parts) {
        if (parts.isEmpty() || !gear.m_41619_() && GearHelper.isBroken(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        for (PartData part : parts) {
            PartGearKey key = PartGearKey.of(gearType, part);
            for (TraitInstance inst : part.getTraits(key, gear)) {
                if (!inst.conditionsMatch(key, gear, parts)) continue;
                ITrait trait = inst.getTrait();
                result.merge(trait, inst.getLevel(), Integer::max);
            }
        }
        ITrait[] keys = result.keySet().toArray(new ITrait[0]);
        TraitHelper.cancelTraits(result, keys);
        MinecraftForge.EVENT_BUS.post((Event)new GetTraitsEvent(gear, parts, result));
        return result;
    }

    public static List<TraitInstance> getTraits(List<? extends IGearComponentInstance<?>> components, PartGearKey partKey, ItemStack gear) {
        ITrait[] keys;
        if (components.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<ITrait, Integer> map = new LinkedHashMap<ITrait, Integer>();
        HashMap<ITrait, Integer> countMatsWithTrait = new HashMap<ITrait, Integer>();
        for (IGearComponentInstance<?> iGearComponentInstance : components) {
            for (TraitInstance inst : iGearComponentInstance.getTraits(partKey, gear)) {
                if (!inst.conditionsMatch(partKey, gear, components)) continue;
                map.merge(inst.getTrait(), inst.getLevel(), Integer::sum);
                countMatsWithTrait.merge(inst.getTrait(), 1, Integer::sum);
            }
        }
        for (ITrait trait2 : keys = map.keySet().toArray(new ITrait[0])) {
            int matsWithTrait = (Integer)countMatsWithTrait.get(trait2);
            float divisor = Math.max((float)components.size() / 2.0f, (float)matsWithTrait);
            int value = Math.round((float)((Integer)map.get(trait2)).intValue() / divisor);
            map.put(trait2, Mth.m_14045_((int)value, (int)1, (int)trait2.getMaxLevel()));
        }
        TraitHelper.cancelTraits(map, keys);
        ArrayList<TraitInstance> arrayList = new ArrayList<TraitInstance>();
        map.forEach((trait, level) -> ret.add(TraitInstance.of(trait, (int)level, new ITraitCondition[0])));
        return arrayList;
    }

    private static void cancelTraits(Map<ITrait, Integer> mapToModify, ITrait[] keys) {
        block0: for (int i = 0; i < keys.length; ++i) {
            ITrait t1 = keys[i];
            if (!mapToModify.containsKey(t1)) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                int otherLevel;
                ITrait t2 = keys[j];
                if (!mapToModify.containsKey(t2) || !t1.willCancelWith(t2)) continue;
                int level = mapToModify.get(t1);
                int cancelLevel = t1.getCanceledLevel(level, t2, otherLevel = mapToModify.get(t2).intValue());
                if (cancelLevel > 0) {
                    mapToModify.put(t1, cancelLevel);
                    mapToModify.remove(t2);
                    continue;
                }
                if (cancelLevel < 0) {
                    mapToModify.put(t2, -cancelLevel);
                    mapToModify.remove(t1);
                    continue block0;
                }
                mapToModify.remove(t1);
                mapToModify.remove(t2);
                continue block0;
            }
        }
    }

    static void tickTraits(Level world, @Nullable Player player, ItemStack gear, boolean isEquipped) {
        ListTag tagList = GearData.getPropertiesData(gear).m_128437_("Traits", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tagCompound = tagList.m_128728_(i);
            String regName = tagCompound.m_128461_("Name");
            ITrait trait = TraitManager.get(regName);
            if (trait == null) continue;
            byte level = tagCompound.m_128445_("Level");
            TraitActionContext context = new TraitActionContext(player, level, gear);
            trait.onUpdate(context, isEquipped);
        }
    }
}

