/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.util.ModResourceLocation;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ModWorldFeatures {
    public static final RuleTest END_STONE_RULE_TEST = new TagMatchTest((Tag)Tags.Blocks.END_STONES);
    public static final Lazy<TreeConfiguration> NETHERWOOD_TREE_CONFIG = Lazy.of(() -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.NETHERWOOD_LOG.asBlockState()), (TrunkPlacer)new ForkingTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.NETHERWOOD_LEAVES.asBlockState()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_());
    private static boolean configuredFeaturesRegistered = false;

    private ModWorldFeatures() {
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
    }

    private static void registerConfiguredFeatures() {
        if (configuredFeaturesRegistered) {
            return;
        }
        configuredFeaturesRegistered = true;
        Configured.TO_REGISTER.forEach((name, cf) -> ModWorldFeatures.registerConfiguredFeature(name, (ConfiguredFeature)cf.get()));
    }

    private static void registerConfiguredFeature(String name, ConfiguredFeature<?, ?> configuredFeature) {
        ModResourceLocation id = SilentGear.getId(name);
        ModWorldFeatures.debugLog("Register configured feature " + id);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)id, configuredFeature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent biome) {
        ModWorldFeatures.registerConfiguredFeatures();
        if (biome.getCategory() == Biome.BiomeCategory.NETHER) {
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        } else if (biome.getCategory() == Biome.BiomeCategory.THEEND) {
            ModWorldFeatures.addAzureSilverOre(biome);
        } else {
            ModWorldFeatures.addBortOre(biome);
            if (biome.getCategory() == Biome.BiomeCategory.EXTREME_HILLS || biome.getCategory() == Biome.BiomeCategory.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.getClimate().f_47683_ > 0.4f) {
                ModWorldFeatures.addWildFluffyPlants(biome);
            }
        }
    }

    private static void addWildFlax(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild flax to " + biome.getName());
        biome.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, (PlacedFeature)Placed.FLOWER_WILD_FLAX.get());
    }

    private static void addWildFluffyPlants(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild fluffy plants to " + biome.getName());
        biome.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, (PlacedFeature)Placed.FLOWER_WILD_FLUFFY.get());
    }

    private static void addNetherwoodTrees(BiomeLoadingEvent biome) {
    }

    private static void addBortOre(BiomeLoadingEvent biome) {
        biome.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, (PlacedFeature)Placed.ORE_BORT.get());
    }

    private static void addCrimsonIronOre(BiomeLoadingEvent biome) {
        if (Biomes.f_48175_.m_135782_().equals((Object)biome.getName()) || Biomes.f_48199_.m_135782_().equals((Object)biome.getName())) {
            ModWorldFeatures.debugLog("Add double crimson iron ores to " + biome.getName());
            biome.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, (PlacedFeature)Placed.ORE_CRIMSON_IRON_DOUBLE.get());
        } else {
            ModWorldFeatures.debugLog("Add crimson iron ores to " + biome.getName());
            biome.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, (PlacedFeature)Placed.ORE_CRIMSON_IRON.get());
        }
    }

    private static void addAzureSilverOre(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add azure silver ores to " + biome.getName());
        biome.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, (PlacedFeature)Placed.ORE_AZURE_SILVER.get());
    }

    private static void debugLog(String msg) {
        if (((Boolean)Config.Common.worldGenLogging.get()).booleanValue()) {
            SilentGear.LOGGER.debug(msg);
        }
    }

    public static final class Configured {
        static final Map<String, Lazy<ConfiguredFeature<?, ?>>> TO_REGISTER = new LinkedHashMap();
        public static final Lazy<ConfiguredFeature<?, ?>> BORT_ORE_VEINS = Configured.createLazy("bort_ore_veins", () -> {
            ImmutableList targetList = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((OreBlock)ModBlocks.BORT_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((OreBlock)ModBlocks.DEEPSLATE_BORT_ORE.get()).m_49966_()));
            return Feature.f_159732_.m_65815_((FeatureConfiguration)new ReplaceBlockConfiguration((List)targetList));
        });
        public static final Lazy<ConfiguredFeature<?, ?>> CRIMSON_IRON_ORE_VEINS = Configured.createLazy("crimson_iron_ore_veins", () -> Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreFeatures.f_195075_, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 8)));
        public static final Lazy<ConfiguredFeature<?, ?>> AZURE_SILVER_ORE_VEINS = Configured.createLazy("azure_silver_ore_veins", () -> Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(END_STONE_RULE_TEST, ModBlocks.AZURE_SILVER_ORE.asBlockState(), 6)));
        public static final Lazy<ConfiguredFeature<?, ?>> WILD_FLAX_PATCHES = Configured.createLazy("wild_flax_patches", () -> Feature.f_65761_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration(32, 6, 2, () -> Feature.f_65741_.m_65815_((FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILD_FLAX_PLANT.get())))).m_190825_())));
        public static final Lazy<ConfiguredFeature<?, ?>> WILD_FLUFFY_PATCHES = Configured.createLazy("wild_fluffy_plant_patches", () -> Feature.f_65761_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration(32, 6, 2, () -> Feature.f_65741_.m_65815_((FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILD_FLUFFY_PLANT.get())))).m_190825_())));

        private static Lazy<ConfiguredFeature<?, ?>> createLazy(String name, Supplier<ConfiguredFeature<?, ?>> supplier) {
            if (TO_REGISTER.containsKey(name)) {
                throw new IllegalArgumentException("Configured feature lazy with name '" + name + "' already created");
            }
            Lazy lazy = Lazy.of(supplier);
            TO_REGISTER.put(name, lazy);
            return lazy;
        }

        private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
            return FeatureUtils.m_194991_((int)p_195204_, (PlacedFeature)Feature.f_65741_.m_65815_((FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)).m_190825_());
        }

        private Configured() {
        }
    }

    public static final class Placed {
        public static final Lazy<PlacedFeature> ORE_BORT = Placed.create("ore_bort", () -> ((ConfiguredFeature)Configured.BORT_ORE_VEINS.get()).m_190821_(Placed.commonOrePlacement((Integer)Config.Common.bortCount.get(), (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-60), (VerticalAnchor)VerticalAnchor.m_158922_((int)10)))));
        public static final Lazy<PlacedFeature> ORE_CRIMSON_IRON = Placed.create("ore_crimson_iron", () -> ((ConfiguredFeature)Configured.CRIMSON_IRON_ORE_VEINS.get()).m_190821_(Placed.commonOrePlacement((Integer)Config.Common.crimsonIronCount.get(), PlacementUtils.f_195357_)));
        public static final Lazy<PlacedFeature> ORE_CRIMSON_IRON_DOUBLE = Placed.create("ore_crimson_iron_double", () -> ((ConfiguredFeature)Configured.CRIMSON_IRON_ORE_VEINS.get()).m_190821_(Placed.commonOrePlacement(2 * (Integer)Config.Common.crimsonIronCount.get(), PlacementUtils.f_195357_)));
        public static final Lazy<PlacedFeature> ORE_AZURE_SILVER = Placed.create("ore_azure_silver", () -> ((ConfiguredFeature)Configured.AZURE_SILVER_ORE_VEINS.get()).m_190821_(Placed.commonOrePlacement((Integer)Config.Common.azureSilverCount.get(), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)16), (VerticalAnchor)VerticalAnchor.m_158922_((int)92)))));
        public static final Lazy<PlacedFeature> FLOWER_WILD_FLAX = Placed.create("flower_wild_flax", () -> ((ConfiguredFeature)Configured.WILD_FLAX_PATCHES.get()).m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
        public static final Lazy<PlacedFeature> FLOWER_WILD_FLUFFY = Placed.create("flower_wild_fluffy", () -> ((ConfiguredFeature)Configured.WILD_FLUFFY_PATCHES.get()).m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));

        private static Lazy<PlacedFeature> create(String name, Supplier<PlacedFeature> supplier) {
            return Lazy.of(supplier);
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
            return Placed.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
        }

        private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
            return Placed.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
        }

        private Placed() {
        }
    }
}

