/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.create;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.List;

public class ProcessingRecipeJS
extends RecipeJS {
    public final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    public final List<net.minecraftforge.fluids.FluidStack> outputFluids = new ArrayList<net.minecraftforge.fluids.FluidStack>();

    public void create(ListJS args) {
        FluidStackJS fluid;
        for (Object result : ListJS.orSelf((Object)args.get(0))) {
            if (result instanceof FluidStackJS) {
                fluid = (FluidStackJS)result;
                this.outputFluids.add(FluidStackHooksForge.toForge((FluidStack)fluid.getFluidStack()));
                continue;
            }
            this.outputItems.add(this.parseResultItem(result));
        }
        for (Object input : ListJS.orSelf((Object)args.get(1))) {
            MapJS map;
            if (input instanceof FluidStackJS) {
                fluid = (FluidStackJS)input;
                this.inputFluids.add(FluidIngredient.fromFluidStack((net.minecraftforge.fluids.FluidStack)FluidStackHooksForge.toForge((FluidStack)fluid.getFluidStack())));
                continue;
            }
            if (input instanceof MapJS && ((map = (MapJS)input).containsKey((Object)"fluid") || map.containsKey((Object)"fluidTag"))) {
                this.inputFluids.add(FluidIngredient.deserialize((JsonElement)map.toJson()));
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(input));
        }
        this.json.addProperty("processingTime", (Number)100);
    }

    public void deserialize() {
        for (JsonElement ingredient : this.json.get("ingredients").getAsJsonArray()) {
            if (FluidIngredient.isFluidIngredient((JsonElement)ingredient)) {
                this.inputFluids.add(FluidIngredient.deserialize((JsonElement)ingredient));
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(ingredient));
        }
        for (JsonElement result : this.json.get("results").getAsJsonArray()) {
            JsonObject resultJson = result.getAsJsonObject();
            if (resultJson.has("fluid")) {
                this.outputFluids.add(FluidHelper.deserializeFluidStack((JsonObject)resultJson));
                continue;
            }
            this.outputItems.add(this.parseResultItem(result));
        }
    }

    public ProcessingRecipeJS processingTime(int t) {
        this.json.addProperty("processingTime", (Number)t);
        this.save();
        return this;
    }

    public ProcessingRecipeJS heatRequirement(String req) {
        this.json.addProperty("heatRequirement", req);
        this.save();
        return this;
    }

    public ProcessingRecipeJS heated() {
        return this.heatRequirement("heated");
    }

    public ProcessingRecipeJS superheated() {
        return this.heatRequirement("superheated");
    }

    public void serialize() {
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        for (IngredientJS ingredientJS : this.inputItems) {
            for (IngredientJS ingredient : ingredientJS.unwrapStackIngredient()) {
                jsonIngredients.add(ingredient.toJson());
            }
        }
        for (FluidIngredient fluidIngredient : this.inputFluids) {
            jsonIngredients.add((JsonElement)fluidIngredient.serialize());
        }
        for (ItemStackJS itemStackJS : this.outputItems) {
            jsonOutputs.add(itemStackJS.toResultJson());
        }
        for (net.minecraftforge.fluids.FluidStack fluidStack : this.outputFluids) {
            jsonOutputs.add(FluidHelper.serializeFluidStack((net.minecraftforge.fluids.FluidStack)fluidStack));
        }
        this.json.add("ingredients", (JsonElement)jsonIngredients);
        this.json.add("results", (JsonElement)jsonOutputs);
    }
}

